(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    249342,       6949]*)
(*NotebookOutlinePosition[    250566,       6989]*)
(*  CellTagsIndexPosition[    250432,       6982]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Examples 7.4", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Load LPT.m"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(<< Library/Mathematica/Applications/RossDE/LPT.m\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<UnitStep\>", LongForm \[Rule] False]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"\<\"UnitStep[x] represents the unit step function, equal to 0 \
for x < 0 and 1 for x \[GreaterEqual] 0. UnitStep[x1, x2, ... ] represents \
the multidimensional unit step function which is 1 only if none of the xi are \
negative.\"\>", " ", 
      ButtonBox[
        StyleBox["More\[Ellipsis]",
          "SR"],
        ButtonData:>"UnitStep",
        Active->True,
        ButtonStyle->"RefGuideLink"]}]], "Print",
  CellTags->"Info3307101380-4970032"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<UnitPulse\>", LongForm \[Rule] False]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("UnitPulse[t,a,b] when a<b, is 0 if t<a or t>b and 1 when a<=t<=b; it \
evaluates to 1 if t>a or t<b and 0 when b<=t<=a."\)], "Print",
  CellTags->"Info3307101381-9388658"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Plot Unit Step and UnitPulse"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[UnitStep[t - 1], {t, 0, 3}, Ticks \[Rule] {{{1, c}}, {{1, 1}}}, 
        AspectRatio \[Rule] Automatic];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33333 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00793651 0.31746 [
[.34127 -0.00456 -5 -12 ]
[.34127 -0.00456 5 0 ]
[.01131 .3254 -6 -4.5 ]
[.01131 .3254 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .33333 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.34127 .00794 m
.34127 .01419 L
s
gsave
.34127 -0.00456 -66 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c) show
1.000 setlinewidth
grestore
0 .00794 m
1 .00794 L
s
.02381 .3254 m
.03006 .3254 L
s
[(1)] .01131 .3254 1 0 Mshowa
.02381 0 m
.02381 .33333 L
s
0 0 m
1 0 L
1 .33333 L
0 .33333 L
closepath
clip
newpath
.5 Mabswid
.02381 .00794 m
.06244 .00794 L
.10458 .00794 L
.14415 .00794 L
.18221 .00794 L
.22272 .00794 L
.26171 .00794 L
.28158 .00794 L
.30316 .00794 L
.31323 .00794 L
.32392 .00794 L
.33304 .00794 L
.33554 .00794 L
.33823 .00794 L
.33953 .00794 L
.34076 .00794 L
.34187 .3254 L
.34309 .3254 L
.38373 .3254 L
.42286 .3254 L
.46444 .3254 L
.50451 .3254 L
.54306 .3254 L
.58406 .3254 L
.62355 .3254 L
.66152 .3254 L
.70195 .3254 L
.74085 .3254 L
.78222 .3254 L
.82206 .3254 L
.86039 .3254 L
.90117 .3254 L
.94044 .3254 L
.97619 .3254 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{258, 85.9375},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000420000EB000`400?l00000o`00003oooooool3
ooooo`00ooooool3ooooo`00ooooool3ooooo`00ooooool3ooooo`00Goooool3o`000:3ooooo001N
ooooo`05o`000?ooooooooooooooool00000Woooool005kooooo00?o0000ooooooooool0XOooool0
05kooooo00Go0000ooooooooooooooooo`00002Oooooo`00Goooool3o`000:3ooooo003oooooo`?o
oooo003oooooo`?ooooo003oooooo`?ooooo003oooooo`?ooooo000Oooooo`03o`000?oooooooooo
0>3ooooo000Jooooom7o00005oooool001oooooo00?o0000ooooooooool0?oooool00ol0003ooooo
ooooo`2Nooooo`007oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo000O
ooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0W_ooool001oooooo00?o0000oooo
ooooool0?oooool00ol0003oooooooooo`2Nooooo`007oooool00ol0003oooooooooo`0oooooo`03
o`000?oooooooooo09kooooo000Oooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0
W_ooool001oooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`2Nooooo`007oooool0
0ol0003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo000Oooooo`03o`000?oooooooooo
03oooooo00?o0000ooooooooool0W_ooool001oooooo00?o0000ooooooooool0?oooool00ol0003o
ooooooooo`2Nooooo`007oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo
000Oooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0W_ooool001oooooo00?o0000
ooooooooool0?oooool00ol0003oooooooooo`2Nooooo`007oooool00ol0003oooooooooo`0ooooo
o`03o`000?oooooooooo09kooooo000Oooooo`03o`000?oooooooooo03oooooo00?o0000oooooooo
ool0W_ooool001oooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`2Nooooo`007ooo
ool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo000Oooooo`03o`000?oooooo
oooo03oooooo00?o0000ooooooooool0W_ooool001oooooo00?o0000ooooooooool0?oooool00ol0
003oooooooooo`2Nooooo`007oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo09ko
oooo000Oooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0W_ooool001oooooo00?o
0000ooooooooool0?oooool00ol0003oooooooooo`2Nooooo`007oooool00ol0003oooooooooo`0o
ooooo`03o`000?oooooooooo09kooooo000Oooooo`03o`000?oooooooooo03oooooo00?o0000oooo
ooooool0W_ooool001oooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`2Nooooo`00
7oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo000Oooooo`03o`000?oo
oooooooo03oooooo00?o0000ooooooooool0W_ooool001oooooo00?o0000ooooooooool0?oooool0
0ol0003oooooooooo`2Nooooo`007oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo
09kooooo000Oooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0W_ooool001oooooo
00?o0000ooooooooool0?oooool00ol0003oooooooooo`2Nooooo`007oooool00ol0003ooooooooo
o`0oooooo`03o`000?oooooooooo09kooooo000Oooooo`03o`000?oooooooooo03oooooo00?o0000
ooooooooool0W_ooool001oooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`2Noooo
o`007oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo000Oooooo`03o`00
0?oooooooooo03oooooo00?o0000ooooooooool0W_ooool001oooooo00?o0000ooooooooool0?ooo
ool00ol0003oooooooooo`2Nooooo`007oooool00ol0003oooooooooo`0oooooo`03o`000?oooooo
oooo09kooooo000Oooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0W_ooool001oo
oooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`2Nooooo`007oooool00ol0003ooooo
ooooo`0oooooo`03o`000?oooooooooo09kooooo000Oooooo`03o`000?oooooooooo03oooooo00?o
0000ooooooooool0W_ooool001oooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`2N
ooooo`007oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo000Oooooo`03
o`000?oooooooooo03oooooo00?o0000ooooooooool0W_ooool001oooooo00?o0000ooooooooool0
?oooool00ol0003oooooooooo`2Nooooo`007oooool00ol0003oooooooooo`0oooooo`03o`000?oo
oooooooo09kooooo000Oooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0W_ooool0
01oooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`2Nooooo`007oooool00ol0003o
ooooooooo`0oooooo`03o`000?oooooooooo09kooooo000Oooooo`03o`000?oooooooooo03oooooo
00?o0000ooooooooool0W_ooool001oooooo00?o0000ooooooooool0?oooool00ol0003ooooooooo
o`2Nooooo`007oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo000Ooooo
o`03o`000?oooooooooo03oooooo00?o0000ooooooooool0W_ooool001oooooo00?o0000oooooooo
ool0?oooool00ol0003oooooooooo`2Nooooo`007oooool00ol0003oooooooooo`0oooooo`03o`00
0?oooooooooo09kooooo000Oooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0W_oo
ool001oooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`2Nooooo`007oooool00ol0
003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo000Oooooo`03o`000?oooooooooo03oo
oooo00?o0000ooooooooool0W_ooool001oooooo00?o0000ooooooooool0?oooool00ol0003ooooo
ooooo`2Nooooo`007oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo000G
ooooo`?o00001Oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo09kooooo000Hoooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`2Noooo
o`006?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo03oooooo00?o0000oooooooo
ool0W_ooool001Sooooo00?o0000ooooooooool01?ooool2o`00043oooooQOl0000Looooo`006?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0>3ooooo000Gooooo`;o00001_ooool0
0ol0003oooooooooo`3Pooooo`006?ooool00ol0003oooooooooo`3Wooooo`00ooooool3ooooo`00
\
\>"],
  ImageRangeCache->{{{0, 257}, {84.9375, 0}} -> {-0.479324, -0.221618, \
0.0151874, 0.0151874}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[UnitPulse[t, 1, 2], {t, 0, 3}, 
        Ticks \[Rule] {{{1, a}, {2, b}}, {{1, 1}}}, 
        AspectRatio \[Rule] Automatic];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33333 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00793651 0.31746 [
[.34127 -0.00456 -5 -12 ]
[.34127 -0.00456 5 0 ]
[.65873 -0.00456 -5 -12 ]
[.65873 -0.00456 5 0 ]
[.01131 .3254 -6 -4.5 ]
[.01131 .3254 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .33333 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.34127 .00794 m
.34127 .01419 L
s
gsave
.34127 -0.00456 -66 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
1.000 setlinewidth
grestore
.65873 .00794 m
.65873 .01419 L
s
gsave
.65873 -0.00456 -66 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
1.000 setlinewidth
grestore
0 .00794 m
1 .00794 L
s
.02381 .3254 m
.03006 .3254 L
s
[(1)] .01131 .3254 1 0 Mshowa
.02381 0 m
.02381 .33333 L
s
0 0 m
1 0 L
1 .33333 L
0 .33333 L
closepath
clip
newpath
.5 Mabswid
.02381 .00794 m
.06244 .00794 L
.10458 .00794 L
.14415 .00794 L
.18221 .00794 L
.22272 .00794 L
.26171 .00794 L
.28158 .00794 L
.30316 .00794 L
.31323 .00794 L
.32392 .00794 L
.33304 .00794 L
.33554 .00794 L
.33823 .00794 L
.33953 .00794 L
.34076 .00794 L
.34187 .3254 L
.34309 .3254 L
.38373 .3254 L
.42286 .3254 L
.46444 .3254 L
.50451 .3254 L
.54306 .3254 L
.58406 .3254 L
.60448 .3254 L
.62355 .3254 L
.64188 .3254 L
.64715 .3254 L
.65215 .3254 L
.65433 .3254 L
.65664 .3254 L
.65785 .3254 L
.65853 .3254 L
.65918 .00794 L
.66031 .00794 L
.66152 .00794 L
.70266 .00794 L
.74229 .00794 L
.78039 .00794 L
.82096 .00794 L
.86 .00794 L
.9015 .00794 L
.94148 .00794 L
.97619 .00794 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{264, 87.9375},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000480000Eb000`400?l00000o`00003oooooool9
ooooo`00ooooool9ooooo`00ooooool9ooooo`00ooooool9ooooo`00HOooool4o`0003oooooo1?l0
001Pooooo`00H?ooool01?l0003oooooooooool00011ooooo`04o`000?ooooooooooo`0005oooooo
001Qooooo`?o0000@Oooool01?l0003oooooooooool0001Oooooo`00H?ooool01?l0003ooooooooo
ool00011ooooo`04o`000?ooooooooooo`0005oooooo001Qooooo`;o0000@_ooool3o`00063ooooo
002Uooooo`03o`000?oooooooooo063ooooo002Tooooo`;o0000H_ooool00?oooooo2Oooool00?oo
oooo2Oooool001oooooo00?o0000ooooooooool0i_ooool001[oooooeol0000Gooooo`007oooool0
0ol0003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0G_ooool0
01oooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo
05kooooo000Oooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0003o
ooooooooo`1Nooooo`007oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo
00?o0000ooooooooool0G_ooool001oooooo00?o0000ooooooooool0@Oooool00ol0003ooooooooo
o`11ooooo`03o`000?oooooooooo05kooooo000Oooooo`03o`000?oooooooooo047ooooo00?o0000
ooooooooool0@Oooool00ol0003oooooooooo`1Nooooo`007oooool00ol0003oooooooooo`11oooo
o`03o`000?oooooooooo047ooooo00?o0000ooooooooool0G_ooool001oooooo00?o0000oooooooo
ool0@Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo05kooooo000Oooooo`03o`00
0?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Nooooo`007ooo
ool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0G_oo
ool001oooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooo
oooo05kooooo000Oooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0
003oooooooooo`1Nooooo`007oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo047o
oooo00?o0000ooooooooool0G_ooool001oooooo00?o0000ooooooooool0@Oooool00ol0003ooooo
ooooo`11ooooo`03o`000?oooooooooo05kooooo000Oooooo`03o`000?oooooooooo047ooooo00?o
0000ooooooooool0@Oooool00ol0003oooooooooo`1Nooooo`007oooool00ol0003oooooooooo`11
ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0G_ooool001oooooo00?o0000oooo
ooooool0@Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo05kooooo000Oooooo`03
o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Nooooo`00
7oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0
G_ooool001oooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`11ooooo`03o`000?oo
oooooooo05kooooo000Oooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool0
0ol0003oooooooooo`1Nooooo`007oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo
047ooooo00?o0000ooooooooool0G_ooool001oooooo00?o0000ooooooooool0@Oooool00ol0003o
ooooooooo`11ooooo`03o`000?oooooooooo05kooooo000Oooooo`03o`000?oooooooooo047ooooo
00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Nooooo`007oooool00ol0003ooooooooo
o`11ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0G_ooool001oooooo00?o0000
ooooooooool0@Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo05kooooo000Ooooo
o`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Noooo
o`007oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000oooooooo
ool0G_ooool001oooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`11ooooo`03o`00
0?oooooooooo05kooooo000Oooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Ooo
ool00ol0003oooooooooo`1Nooooo`007oooool00ol0003oooooooooo`11ooooo`03o`000?oooooo
oooo047ooooo00?o0000ooooooooool0G_ooool001oooooo00?o0000ooooooooool0@Oooool00ol0
003oooooooooo`11ooooo`03o`000?oooooooooo05kooooo000Oooooo`03o`000?oooooooooo047o
oooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Nooooo`007oooool00ol0003ooooo
ooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0G_ooool001oooooo00?o
0000ooooooooool0@Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo05kooooo000O
ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1N
ooooo`007oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000oooo
ooooool0G_ooool001oooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`11ooooo`03
o`000?oooooooooo05kooooo000Oooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0
@Oooool00ol0003oooooooooo`1Nooooo`007oooool00ol0003oooooooooo`11ooooo`03o`000?oo
oooooooo047ooooo00?o0000ooooooooool0G_ooool001oooooo00?o0000ooooooooool0@Oooool0
0ol0003oooooooooo`11ooooo`03o`000?oooooooooo05kooooo000Oooooo`03o`000?oooooooooo
047ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Nooooo`007oooool00ol0003o
ooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0G_ooool001oooooo
00?o0000ooooooooool0@Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo05kooooo
000Oooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0003ooooooooo
o`1Nooooo`007oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000
ooooooooool0G_ooool001oooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`11oooo
o`03o`000?oooooooooo05kooooo000Oooooo`03o`000?oooooooooo047ooooo00?o0000oooooooo
ool0@Oooool00ol0003oooooooooo`1Nooooo`007oooool00ol0003oooooooooo`11ooooo`03o`00
0?oooooooooo047ooooo00?o0000ooooooooool0G_ooool001oooooo00?o0000ooooooooool0@Ooo
ool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo05kooooo000Oooooo`03o`000?oooooo
oooo047ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Nooooo`007oooool00ol0
003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0G_ooool001oo
oooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo05ko
oooo000Oooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0003ooooo
ooooo`1Nooooo`007oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o
0000ooooooooool0G_ooool001oooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`11
ooooo`03o`000?oooooooooo05kooooo000Oooooo`03o`000?oooooooooo047ooooo00?o0000oooo
ooooool0@Oooool00ol0003oooooooooo`1Nooooo`007oooool00ol0003oooooooooo`11ooooo`03
o`000?oooooooooo047ooooo00?o0000ooooooooool0G_ooool001oooooo00?o0000ooooooooool0
@Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo05kooooo000Oooooo`03o`000?oo
oooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Nooooo`007oooool0
0ol0003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0G_ooool0
01oooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo
05kooooo000Oooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0003o
ooooooooo`1Nooooo`007oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo
00?o0000ooooooooool0G_ooool001Oooooo0ol00005ooooo`03o`000?oooooooooo047ooooo00?o
0000ooooooooool0@Oooool00ol0003oooooooooo`1Nooooo`006?ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1N
ooooo`006?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo047ooooo00?o0000oooo
ooooool0@Oooool00ol0003oooooooooo`1Nooooo`006?ooool00ol0003oooooooooo`04ooooo`;o
0000@_oooom5o`00063ooooo000Hooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
i_ooool001Oooooo0_l00006ooooo`03o`000?oooooooooo0>Kooooo000Hooooo`03o`000?oooooo
oooo0>gooooo003oooooo`Wooooo0000\
\>"],
  ImageRangeCache->{{{0, 263}, {86.9375, 0}} -> {-0.466886, -0.216443, \
0.0147561, 0.0147561}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Plot Discontinuous function, I"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Simple Plot (Note vertical lines)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f[t_] := 
      If[TrueQ[0 \[LessEqual] t \[LessEqual] 1], t\^2, 
        If[TrueQ[1 < t \[LessEqual] 2], 1\/2\ \((t - 3\/2)\)\^2, 
          If[TrueQ[2 < t], 6 - t\^2]]]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p0 = Plot[f[t], {t, \(-1\), 3}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(f[t]\) is not a machine-size real number at \!\(t\) = \
\!\(-0.9999998333333333`\)."\)], "Message"],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(f[t]\) is not a machine-size real number at \!\(t\) = \
\!\(-0.8377320337083368`\)."\)], "Message"],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(f[t]\) is not a machine-size real number at \!\(t\) = \
\!\(-0.6607648005625053`\)."\)], "Message"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Plot :: \"plnr\"\) will be suppressed during \
this calculation."\)], "Message"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.235357 0.559097 [
[.18254 .22286 -9 -9 ]
[.18254 .22286 9 0 ]
[.34127 .22286 -3 -9 ]
[.34127 .22286 3 0 ]
[.5 .22286 -9 -9 ]
[.5 .22286 9 0 ]
[.65873 .22286 -3 -9 ]
[.65873 .22286 3 0 ]
[.81746 .22286 -9 -9 ]
[.81746 .22286 9 0 ]
[.97619 .22286 -3 -9 ]
[.97619 .22286 3 0 ]
[.01131 .01172 -24 -4.5 ]
[.01131 .01172 0 4.5 ]
[.01131 .12354 -24 -4.5 ]
[.01131 .12354 0 4.5 ]
[.01131 .34718 -18 -4.5 ]
[.01131 .34718 0 4.5 ]
[.01131 .459 -18 -4.5 ]
[.01131 .459 0 4.5 ]
[.01131 .57082 -18 -4.5 ]
[.01131 .57082 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .23536 m
.18254 .24161 L
s
[(0.5)] .18254 .22286 0 1 Mshowa
.34127 .23536 m
.34127 .24161 L
s
[(1)] .34127 .22286 0 1 Mshowa
.5 .23536 m
.5 .24161 L
s
[(1.5)] .5 .22286 0 1 Mshowa
.65873 .23536 m
.65873 .24161 L
s
[(2)] .65873 .22286 0 1 Mshowa
.81746 .23536 m
.81746 .24161 L
s
[(2.5)] .81746 .22286 0 1 Mshowa
.97619 .23536 m
.97619 .24161 L
s
[(3)] .97619 .22286 0 1 Mshowa
.125 Mabswid
.05556 .23536 m
.05556 .23911 L
s
.0873 .23536 m
.0873 .23911 L
s
.11905 .23536 m
.11905 .23911 L
s
.15079 .23536 m
.15079 .23911 L
s
.21429 .23536 m
.21429 .23911 L
s
.24603 .23536 m
.24603 .23911 L
s
.27778 .23536 m
.27778 .23911 L
s
.30952 .23536 m
.30952 .23911 L
s
.37302 .23536 m
.37302 .23911 L
s
.40476 .23536 m
.40476 .23911 L
s
.43651 .23536 m
.43651 .23911 L
s
.46825 .23536 m
.46825 .23911 L
s
.53175 .23536 m
.53175 .23911 L
s
.56349 .23536 m
.56349 .23911 L
s
.59524 .23536 m
.59524 .23911 L
s
.62698 .23536 m
.62698 .23911 L
s
.69048 .23536 m
.69048 .23911 L
s
.72222 .23536 m
.72222 .23911 L
s
.75397 .23536 m
.75397 .23911 L
s
.78571 .23536 m
.78571 .23911 L
s
.84921 .23536 m
.84921 .23911 L
s
.88095 .23536 m
.88095 .23911 L
s
.9127 .23536 m
.9127 .23911 L
s
.94444 .23536 m
.94444 .23911 L
s
.25 Mabswid
0 .23536 m
1 .23536 L
s
.02381 .01172 m
.03006 .01172 L
s
[(-0.4)] .01131 .01172 1 0 Mshowa
.02381 .12354 m
.03006 .12354 L
s
[(-0.2)] .01131 .12354 1 0 Mshowa
.02381 .34718 m
.03006 .34718 L
s
[(0.2)] .01131 .34718 1 0 Mshowa
.02381 .459 m
.03006 .459 L
s
[(0.4)] .01131 .459 1 0 Mshowa
.02381 .57082 m
.03006 .57082 L
s
[(0.6)] .01131 .57082 1 0 Mshowa
.125 Mabswid
.02381 .03967 m
.02756 .03967 L
s
.02381 .06763 m
.02756 .06763 L
s
.02381 .09558 m
.02756 .09558 L
s
.02381 .15149 m
.02756 .15149 L
s
.02381 .17945 m
.02756 .17945 L
s
.02381 .2074 m
.02756 .2074 L
s
.02381 .26331 m
.02756 .26331 L
s
.02381 .29127 m
.02756 .29127 L
s
.02381 .31922 m
.02756 .31922 L
s
.02381 .37513 m
.02756 .37513 L
s
.02381 .40309 m
.02756 .40309 L
s
.02381 .43104 m
.02756 .43104 L
s
.02381 .48695 m
.02756 .48695 L
s
.02381 .51491 m
.02756 .51491 L
s
.02381 .54286 m
.02756 .54286 L
s
.02381 .59877 m
.02756 .59877 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02519 .23537 m
.02673 .2354 L
.02842 .23548 L
.02937 .23553 L
.03024 .23559 L
.03198 .23573 L
.03387 .23592 L
.03733 .23637 L
.04052 .23691 L
.04392 .2376 L
.05005 .23918 L
.05782 .24177 L
.06513 .24483 L
.07881 .25214 L
.10438 .27137 L
.13205 .30035 L
.15863 .3362 L
.18672 .38259 L
.23735 .48833 L
.26554 .55953 L
s
.26554 .55953 m
.28625 .61803 L
s
.34062 .61803 m
.34165 .30491 L
.34313 .30362 L
.3705 .28188 L
.39596 .26538 L
.42053 .25288 L
.43418 .24737 L
.44677 .24322 L
.46043 .2397 L
.46762 .23827 L
.47523 .23706 L
.47842 .23665 L
.48184 .23627 L
.4848 .236 L
.48803 .23576 L
.48998 .23564 L
.4918 .23554 L
.49353 .23547 L
.49442 .23544 L
.49538 .23542 L
.49633 .23539 L
.4972 .23538 L
.49891 .23536 L
.50046 .23536 L
.5021 .23537 L
.50373 .2354 L
.50466 .23542 L
.50551 .23544 L
.50704 .23549 L
.50873 .23557 L
.51166 .23573 L
.51477 .23596 L
.52177 .23667 L
.52834 .23758 L
.54012 .23982 L
.5528 .24309 L
.56559 .24729 L
.57957 .25292 L
.60772 .26754 L
.63392 .28511 L
.64146 .29087 L
.64858 .29659 L
.65496 .30196 L
.65671 .30348 L
.65767 .30431 L
.65856 .30509 L
s
.65856 .30509 m
.65904 .61803 L
s
.75535 .61803 m
.76881 .51083 L
.8219 .0564 L
s
.8219 .0564 m
.82807 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{213.875, 132.188},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003E0000Q2000`400?l00000o`00003oeOooool0
0=Gooooo003Eooooo`00eOooool00=Gooooo003Eooooo`00eOooool00=Gooooo0008ooooo`;o0000
1?ooool00ol0003oooooooooo`03ooooo`?o00000oooool00ol0003oooooooooo`2Gooooo`03o`00
0?oooooooooo01kooooo0007ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`2Gooooo`03o`000?oooooooooo01kooooo0005o`0000;ooooo00Co
0000oooooooooooo00001oooool5o`0000?ooooo0_l0002Hooooo`03o`000?oooooooooo01kooooo
0007ooooo`04o`000?ooooooooooo`0000Oooooo00Co0000oooooooooooo00001?ooool00ol0003o
ooooooooo`2Gooooo`03o`000?oooooooooo01kooooo0007ooooo`04o`000?ooooooooooo`0000So
oooo00?o0000ooooool000001?ooool00ol0003oooooooooo`2Fooooo`03o`000?oooooooooo01oo
oooo0007ooooo`04o`000?ooooooooooo`0000Wooooo0_l00004ooooo`03o`000?oooooooooo09Ko
oooo00?o0000ooooooooool07oooool000Sooooo0_l0000;ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool0U_ooool00ol0003oooooooooo`0Oooooo`006_ooool00ol0003ooooooooo
o`2Fooooo`03o`000?oooooooooo01oooooo000Jooooo`;o0000Uoooool00ol0003oooooooooo`0O
ooooo`006_ooool00ol0003oooooooooo`2Eooooo`03o`000?oooooooooo023ooooo000Jooooo`03
o`000?oooooooooo09Gooooo00?o0000ooooooooool08?ooool001[ooooo00?o0000ooooooooool0
UOooool00ol0003oooooooooo`0Pooooo`006_ooool00ol0003oooooooooo`2Eooooo`03o`000?oo
oooooooo023ooooo000Jooooo`;o0000U_ooool00ol0003oooooooooo`0Pooooo`006_ooool00ol0
003oooooooooo`2Eooooo`03o`000?oooooooooo023ooooo000Jooooo`03o`000?oooooooooo09Go
oooo00?o0000ooooooooool08?ooool001[ooooo00?o0000ooooooooool0U?ooool00ol0003ooooo
ooooo`0Qooooo`006_ooool00ol0003oooooooooo`2Dooooo`03o`000?oooooooooo027ooooo000J
ooooo`;o0000UOooool00ol0003oooooooooo`0Qooooo`006_ooool00ol0003oooooooooo`2Doooo
o`03o`000?oooooooooo027ooooo000Jooooo`03o`000?oooooooooo09Cooooo00?o0000oooooooo
ool08Oooool000Sooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go00000oooool00ol0003o
ooooooooo`2Dooooo`03o`000?oooooooooo027ooooo0007ooooo`04o`000?ooooooooooo`0000So
oooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`2Dooooo`03o`000?oooooooooo
027ooooo0005o`0000;ooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo09Cooooo00?o0000ooooooooool08Oooool000Oooooo00Co0000oooooooo
oooo00002_ooool00ol0003oooooooooo`02ooooo`;o0000UOooool00ol0003oooooooooo`0Qoooo
o`001oooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000000oooool0
0ol0003oooooooooo`2Cooooo`03o`000?oooooooooo02;ooooo0007ooooo`04o`000?oooooooooo
o`0000Oooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo09?ooooo00?o
0000ooooooooool08_ooool000Sooooo0_l00009ooooo`?o00001?ooool00ol0003oooooooooo`2C
ooooo`03o`000?oooooooooo02;ooooo000Jooooo`03o`000?oooooooooo09?ooooo00?o0000oooo
ooooool08_ooool001[ooooo0_l0002Dooooo`03o`000?oooooooooo02;ooooo000Jooooo`03o`00
0?oooooooooo09?ooooo00?o0000ooooooooool08_ooool001[ooooo00?o0000ooooooooool0Tooo
ool00ol0003oooooooooo`0Rooooo`006_ooool00ol0003oooooooooo`2Cooooo`03o`000?oooooo
oooo02;ooooo000Jooooo`03o`000?oooooooooo09?ooooo00?o0000ooooooooool08_ooool001[o
oooo0_l0002Cooooo`03o`000?oooooooooo02?ooooo000Jooooo`03o`000?oooooooooo01Cooooo
0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol0000Fooooo`?o00005Oooool3o`0000Cooooo
00?o0000ooooooooool00_ooool3o`0001Cooooo1Ol0000Dooooo`Go000000Coooooo`000?oooooo
00001?ooool3o`0001Gooooo0ol00004ooooo`006_ooool00ol0003oooooooooo`0Cooooo`04o`00
0?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Fooooo`03o`000?oooooooooo
01Gooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000001Cooooo00Co0000
oooooooooooo00005Oooool01_l0003oooooooooool0003oooooo`0000Gooooo00Go0000oooooooo
ooooooooo`00000Cooooo`05o`000?ooooooooooooooool000000oooool001[ooooo00?o0000oooo
ooooool04oooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo01Cooooo00?o0000
ooooooooool05Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool05_ooool01Ol0003ooooooooooooooooo000000Wooooo00?o0000ooooooooool05Ooo
ool00ol0003oooooooooo`01ooooo`006_ooool00ol0003oooooooooo`0Cooooo`04o`000?oooooo
ooooo`0000_ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Eooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Fooooo`04o`000?oo
ooooooooo`0000Wooooo00?o0000ooooooooool04oooool2o`0000Cooooo000Jooooo`03o`000?oo
oooooooo01?ooooo00Co0000oooooooooooo00001oooool4o`0001Oooooo00?o0000ooooooooool0
5Oooool00ol0003oooooooooo`07ooooo`Co00005?ooool01Ol0003ooooooooooooooooo000001Co
oooo00Oo0000ooooooooooooooooo`000?oooooo000000Gooooo1?l0000Hooooo`03o`000?oooooo
oooo007ooooo000Jooooo`;o00005?ooool01?l0003oooooooooool00007ooooo`03o`000?oooooo
oooo01Oooooo0_l0000Fooooo`;o00002Oooool00ol0003oooooooooo`0Eooooo`05o`000?oooooo
ooooooooool000005?ooool01ol0003ooooooooooooooooo0000ooooool000001Oooool00ol0003o
ooooooooo`0Eooooo`05o`000?ooooooooooooooool000000oooool001[ooooo00?o0000oooooooo
ool05?ooool2o`0000Sooooo1Ol0000Fooooo`03o`000?oooooooooo01Gooooo00?o0000oooooooo
ool01oooool5o`0001Cooooo0ol0000Fooooo`?o00000_ooool00ol0003oooooooooo`03ooooo`Go
00005?ooool3o`0000Cooooo000Jooooo`03o`000?oooooooooo097ooooo00?o0000ooooooooool0
9?ooool001[ooooo00?o0000ooooooooool0TOooool00ol0003oooooooooo`0Tooooo`006_ooool0
0ol0003oooooooooo`2Aooooo`03o`000?oooooooooo02Cooooo000Eoooool3o0000000Jooooo`03
o`000?oooooooooo00;ooooo0ol00004ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool00oooool7o`0000Gooooo00?o0000ooooooooool00oooool00ol0003oooooo`000004o`0000Go
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?o
oooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool00_ooool001[ooooo00?o0000ooooooooool01Oooool2o`0004?o
oooo0ol0000Gooooo`?o0000:_ooool00ol0003oooooooooo`0Tooooo`006_ooool00ol0003ooooo
ooooo`07ooooo`;o0000?oooool2o`0001gooooo0_l0000Xooooo`03o`000?oooooooooo02Cooooo
000Jooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0>_ooool2o`00027ooooo0_l0
000Vooooo`03o`000?oooooooooo02Cooooo000Jooooo`;o00002oooool00ol0003oooooooooo`0h
ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0T
ooooo`006_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo03Gooooo0_l0000Woooo
o`;o00008_ooool00ol0003oooooooooo`0Uooooo`006_ooool00ol0003oooooooooo`0<ooooo`;o
0000<oooool2o`0002_ooooo0_l0000Pooooo`03o`000?oooooooooo02Gooooo000Jooooo`03o`00
0?oooooooooo00kooooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`0]ooooo`03o`00
0?oooooooooo01gooooo00?o0000ooooooooool09Oooool001[ooooo00?o0000ooooooooool03ooo
ool00ol0003oooooooooo`0/ooooo`;o0000<Oooool00ol0003oooooooooo`0Looooo`03o`000?oo
oooooooo02Gooooo000Jooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0:_ooool0
0ol0003oooooooooo`0booooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool09Oooool0
01[ooooo0_l0000Booooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool0=?ooool00ol0
003oooooooooo`0Jooooo`03o`000?oooooooooo02Gooooo000Jooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo01Wo
oooo00?o0000ooooooooool09Oooool001[ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`0Uooooo`03o`000?oooooooooo03Sooooo0_l0000Iooooo`03o`000?oooooooooo02Gooooo
000Jooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool09?ooool00ol0003ooooooooo
o`0iooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool09Oooool001[ooooo00?o0000
ooooooooool05?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo03Wooooo00?o0000
ooooooooool05_ooool00ol0003oooooooooo`0Vooooo`006_ooool2o`0001Kooooo00?o0000oooo
ooooool08_ooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo01Kooooo00?o0000oooo
ooooool09_ooool001[ooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0Rooooo`03
o`000?oooooooooo03Wooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Vooooo`00
6_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool0
>Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo02Kooooo0008ooooo`;o00001?oo
ool01?l0003oooooooooooooool5o`0000?ooooo00?o0000ooooooooool05oooool00ol0003ooooo
ooooo`0Pooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool05_ooool00ol0003ooooo
ooooo`0Vooooo`001oooool01?l0003oooooooooool00008ooooo`04o`000?ooooooooooo`0000?o
oooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo03Wo
oooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Vooooo`001oooool01?l0003ooooo
ooooool00009ooooo`03o`000?oooooooooo00?ooooo0_l0000Iooooo`03o`000?oooooooooo01oo
oooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo02Ko
oooo0007ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`0Hooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool0>Oooool00ol0003o
ooooooooo`0Fooooo`03o`000?oooooooooo02Kooooo0007ooooo`04o`000?ooooooooooo`0000Oo
oooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo01Wooooo00?o0000oooo
ooooool07_ooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo01Kooooo00?o0000oooo
ooooool09_ooool000Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo
000000?ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0Mooooo`03o`000?oooooo
oooo03Wooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0Wooooo`002?ooool2o`00
00Wooooo0ol00004ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool07Oooool00ol0
003oooooooooo`0iooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool09oooool001[o
oooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo03Wo
oooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0Wooooo`006_ooool2o`0001cooooo
00?o0000ooooooooool07?ooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo01Gooooo
00?o0000ooooooooool09oooool001[ooooo00?o0000ooooooooool07?ooool00ol0003ooooooooo
o`0Kooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool05Oooool00ol0003ooooooooo
o`0Wooooo`006_ooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo01_ooooo00?o0000
ooooooooool0>Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo02Oooooo000Joooo
o`03o`000?oooooooooo01gooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0ioooo
o`03o`000?oooooooooo01Gooooo00?o0000ooooooooool09oooool001[ooooo00?o0000oooooooo
ool07Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo03Wooooo00?o0000oooooooo
ool05Oooool00ol0003oooooooooo`0Wooooo`006_ooool2o`0001oooooo00?o0000ooooooooool0
6Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0
:?ooool001[ooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0Iooooo`03o`000?oo
oooooooo03Wooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Xooooo`006_ooool0
0ol0003oooooooooo`0Oooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0>Oooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooooooo02Sooooo000Jooooo`03o`000?oooooooooo
01oooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo
01Cooooo00?o0000ooooooooool0:?ooool001[ooooo00?o0000ooooooooool08?ooool00ol0003o
ooooooooo`0Gooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool05?ooool00ol0003o
ooooooooo`0Xooooo`006_ooool2o`00027ooooo00?o0000ooooooooool05oooool00ol0003ooooo
ooooo`0iooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0:?ooool001[ooooo00?o
0000ooooooooool08Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo03Wooooo00?o
0000ooooooooool05?ooool00ol0003oooooooooo`0Xooooo`006_ooool00ol0003oooooooooo`0Q
ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0D
ooooo`03o`000?oooooooooo02Sooooo0008ooooo`;o00001?ooool00ol0003oooooooooo`03oooo
o`?o00000oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo01Gooooo00?o0000oooo
ooooool0>Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo02Sooooo0007ooooo`04
o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Roooo
o`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0Coooo
o`03o`000?oooooooooo02Wooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo1Ol00003oooo
o`03o`000?oooooooooo02?ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0ioooo
o`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0:Oooool000Oooooo00Co0000oooooooo
oooo00001oooool01?l0003oooooooooool00004ooooo`;o00009?ooool00ol0003oooooooooo`0D
ooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Y
ooooo`001oooool01?l0003oooooooooool00008ooooo`03o`000?oooooo000000Cooooo00?o0000
ooooooooool09?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo03[ooooo00?o0000
ooooooooool04oooool00ol0003oooooooooo`0Yooooo`001oooool01?l0003oooooooooool00009
ooooo`;o00001?ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0>_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo02Wooooo0008oooo
o`;o00002oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02Gooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo01?ooooo00?o0000oooo
ooooool0:Oooool001[ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo03[ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Yooooo`00
6_ooool2o`0002Oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0jooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool0:Oooool001[ooooo00?o0000ooooooooool09_oo
ool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`0Yooooo`006_ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo02[ooooo000Jooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool03oooool00ol0
003oooooooooo`0jooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:_ooool001[o
oooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo03[o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Zooooo`006_ooool2o`0002Wooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0:_ooool001[ooooo00?o0000ooooooooool0:?ooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Zooooo`006_ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00kooooo00?o0000
ooooooooool0>_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo02[ooooo000Joooo
o`03o`000?oooooooooo02Wooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0joooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:_ooool001[ooooo00?o0000oooooooo
ool0:Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo03[ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0Zooooo`006_ooool00ol0003oooooooooo`0Yooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo02[ooooo000Jooooo`;o0000:oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo03[ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0[ooooo`006_ooool0
0ol0003oooooooooo`0Zooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0>_ooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02_ooooo000Jooooo`03o`000?oooooooooo
02[ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0:oooool000Sooooo0_l00004ooooo`03o`000?oooooooooo00;o
oooo0ol00004ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0jooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0:oooool000Oooooo
00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooo
ooooool0:oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo03[ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0[ooooo`001oooool01?l0003oooooooooool00007oooo
o`05o`000?ooooooooooooooool000000oooool2o`0002gooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0jooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0:oooool0
00Oooooo00Co0000oooooooooooo00001oooool4o`0000Cooooo00?o0000ooooooooool0;?ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0[ooooo`001oooool01?l0003oooooooooool00007ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo03[ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0[ooooo`001oooool01?l0
003oooooooooool00008ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0;Oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0[ooooo`002?ooool2o`0000[ooooo0_l00004ooooo`03o`000?oooooooooo
02gooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0:oooool001[ooooo0_l0000^ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo02co
oooo000Jooooo`03o`000?oooooooooo02kooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`0jooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0;?ooool001[ooooo00?o
0000ooooooooool0;_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo03[ooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0/ooooo`006_ooool00ol0003oooooooooo`0^
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo02cooooo000Jooooo`03o`000?oooooooooo02oooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool0;?ooool00=Gooooo003Eooooo`00eOooool00=Gooooo003Eooooo`00\
\>"],
  ImageRangeCache->{{{0, 212.875}, {131.188, 0}} -> {-0.435131, -0.492977, \
0.0164893, 0.00936274}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Plot in sections & Combine (No vertical lines)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(g[t_] := t\^2 /; TrueQ[0 \[LessEqual] t \[LessEqual] 1]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(g[t_] := 
      1\/2\ \((t - 3\/2)\)\^2 /; TrueQ[1 < t \[LessEqual] 2]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(g[t_] := 6 - t\^2 /; TrueQ[2 < t]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p1 = 
        Plot[g[t], {t, 0, 1}, 
          PlotRange \[Rule] {{0, 3}, {\(-1\), 2}}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.333333 0.206011 0.206011 [
[.16667 .19351 -9 -9 ]
[.16667 .19351 9 0 ]
[.33333 .19351 -3 -9 ]
[.33333 .19351 3 0 ]
[.5 .19351 -9 -9 ]
[.5 .19351 9 0 ]
[.66667 .19351 -3 -9 ]
[.66667 .19351 3 0 ]
[.83333 .19351 -9 -9 ]
[.83333 .19351 9 0 ]
[1 .19351 -3 -9 ]
[1 .19351 3 0 ]
[-0.0125 0 -12 -4.5 ]
[-0.0125 0 0 4.5 ]
[-0.0125 .10301 -24 -4.5 ]
[-0.0125 .10301 0 4.5 ]
[-0.0125 .30902 -18 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .41202 -6 -4.5 ]
[-0.0125 .41202 0 4.5 ]
[-0.0125 .51503 -18 -4.5 ]
[-0.0125 .51503 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16667 .20601 m
.16667 .21226 L
s
[(0.5)] .16667 .19351 0 1 Mshowa
.33333 .20601 m
.33333 .21226 L
s
[(1)] .33333 .19351 0 1 Mshowa
.5 .20601 m
.5 .21226 L
s
[(1.5)] .5 .19351 0 1 Mshowa
.66667 .20601 m
.66667 .21226 L
s
[(2)] .66667 .19351 0 1 Mshowa
.83333 .20601 m
.83333 .21226 L
s
[(2.5)] .83333 .19351 0 1 Mshowa
1 .20601 m
1 .21226 L
s
[(3)] 1 .19351 0 1 Mshowa
.125 Mabswid
.03333 .20601 m
.03333 .20976 L
s
.06667 .20601 m
.06667 .20976 L
s
.1 .20601 m
.1 .20976 L
s
.13333 .20601 m
.13333 .20976 L
s
.2 .20601 m
.2 .20976 L
s
.23333 .20601 m
.23333 .20976 L
s
.26667 .20601 m
.26667 .20976 L
s
.3 .20601 m
.3 .20976 L
s
.36667 .20601 m
.36667 .20976 L
s
.4 .20601 m
.4 .20976 L
s
.43333 .20601 m
.43333 .20976 L
s
.46667 .20601 m
.46667 .20976 L
s
.53333 .20601 m
.53333 .20976 L
s
.56667 .20601 m
.56667 .20976 L
s
.6 .20601 m
.6 .20976 L
s
.63333 .20601 m
.63333 .20976 L
s
.7 .20601 m
.7 .20976 L
s
.73333 .20601 m
.73333 .20976 L
s
.76667 .20601 m
.76667 .20976 L
s
.8 .20601 m
.8 .20976 L
s
.86667 .20601 m
.86667 .20976 L
s
.9 .20601 m
.9 .20976 L
s
.93333 .20601 m
.93333 .20976 L
s
.96667 .20601 m
.96667 .20976 L
s
.25 Mabswid
0 .20601 m
1 .20601 L
s
0 0 m
.00625 0 L
s
[(-1)] -0.0125 0 1 0 Mshowa
0 .10301 m
.00625 .10301 L
s
[(-0.5)] -0.0125 .10301 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0.5)] -0.0125 .30902 1 0 Mshowa
0 .41202 m
.00625 .41202 L
s
[(1)] -0.0125 .41202 1 0 Mshowa
0 .51503 m
.00625 .51503 L
s
[(1.5)] -0.0125 .51503 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(2)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0206 m
.00375 .0206 L
s
0 .0412 m
.00375 .0412 L
s
0 .0618 m
.00375 .0618 L
s
0 .0824 m
.00375 .0824 L
s
0 .12361 m
.00375 .12361 L
s
0 .14421 m
.00375 .14421 L
s
0 .16481 m
.00375 .16481 L
s
0 .18541 m
.00375 .18541 L
s
0 .22661 m
.00375 .22661 L
s
0 .24721 m
.00375 .24721 L
s
0 .26781 m
.00375 .26781 L
s
0 .28842 m
.00375 .28842 L
s
0 .32962 m
.00375 .32962 L
s
0 .35022 m
.00375 .35022 L
s
0 .37082 m
.00375 .37082 L
s
0 .39142 m
.00375 .39142 L
s
0 .43262 m
.00375 .43262 L
s
0 .45322 m
.00375 .45322 L
s
0 .47383 m
.00375 .47383 L
s
0 .49443 m
.00375 .49443 L
s
0 .53563 m
.00375 .53563 L
s
0 .55623 m
.00375 .55623 L
s
0 .57683 m
.00375 .57683 L
s
0 .59743 m
.00375 .59743 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .20601 m
.00041 .20601 L
.00079 .20601 L
.00122 .20601 L
.00163 .20602 L
.00235 .20602 L
.00314 .20603 L
.00401 .20604 L
.00493 .20606 L
.00658 .20609 L
.00829 .20614 L
.00989 .20619 L
.01352 .20635 L
.01723 .20656 L
.02063 .2068 L
.02827 .20749 L
.03491 .20827 L
.04217 .20931 L
.05639 .21191 L
.07009 .21512 L
.08464 .21929 L
.09867 .22406 L
.11216 .22934 L
.12651 .23569 L
.14033 .24252 L
.15362 .24977 L
.16777 .2582 L
.18139 .26701 L
.19586 .27714 L
.20981 .28763 L
.22322 .2984 L
.2375 .31059 L
.25124 .32305 L
.26445 .33568 L
.27853 .34985 L
.29207 .36417 L
.30646 .38015 L
.32033 .39627 L
.33333 .41202 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`00oooooolJooooo`004oooool3o`000?oooooo1?ooool001Cooooo00?o0000ooooooooool0
ooooool3ooooo`003?ooool5o`0000?ooooo00?o0000ooooooooool01?ooool2o`000?cooooo000D
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0noooool001Cooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`3kooooo`004oooool2o`0000Kooooo00?o0000oooooooo
ool0noooool001Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3kooooo`006ooo
ool00ol0003oooooooooo`3kooooo`006oooool2o`000?cooooo000Kooooo`03o`000?oooooooooo
0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo
000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`;o0000o?ooool001_ooooo00?o0000oooo
ooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0
noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo0_l0003looooo`006oooool00ol0
003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003ooooo
ooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool2o`000?cooooo000Koooo
o`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo0008ooooo`;o0000
1?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`3kooooo`001ooo
ool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003o
ooooooooo`3kooooo`001Ol00002ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000oooooooo
ool00_ooool2o`000?cooooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`3kooooo`001oooool01?l0003oooooooooool00007ooooo`Co
00001Oooool00ol0003oooooooooo`3kooooo`001oooool01?l0003oooooooooool00007ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool0noooool000Sooooo0_l00008ooooo`Go0000
1?ooool00ol0003oooooooooo`3kooooo`006oooool2o`000?cooooo000Kooooo`03o`000?oooooo
oooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_o
oooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000K
ooooo`;o0000o?ooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000oooooooo
ool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool07ooo
ool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`00027ooooo0ol0000Qooooo`?o00001?oo
ool00ol0003oooooooooo`02ooooo`?o00008?ooool5o`0001oooooo1Ol00003ooooo`03o`000?oo
oooooooo00;ooooo0ol0000Pooooo`?o00000oooool001_ooooo0_l0000Oooooo`04o`000?oooooo
ooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Qooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo0000023ooooo00Co0000oooooooo
oooo00008?ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000007_oo
ool01Ol0003ooooooooooooooooo000000;ooooo000Kooooo`03o`000?oooooooooo01kooooo00Co
0000oooooooooooo00002oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0Pooooo`7o00000Oooool1ooooo`006ooo
ool00ol0003oooooooooo`0Nooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool0
7oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
8?ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
7_ooool2o`0000?ooooo000Kooooo`03o`000?oooooooooo01kooooo00Co0000oooooooooooo0000
1oooool4o`0002;ooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`07ooooo`Co0000
8?ooool01Ol0003ooooooooooooooooo000001oooooo00Go0000ooooooooooooooooo`000007oooo
o`Co00008oooool1o`00007ooooo0Oooool001_ooooo00?o0000ooooooooool07_ooool01?l0003o
ooooooooool00007ooooo`03o`000?oooooooooo02;ooooo0_l0000Rooooo`;o00002Oooool00ol0
003oooooooooo`0Qooooo`05o`000?ooooooooooooooool000007oooool01Ol0003ooooooooooooo
oooo000000Oooooo00?o0000ooooooooool08?ooool01Ol0003ooooooooooooooooo000000;ooooo
000Kooooo`;o00008?ooool2o`0000Sooooo1Ol0000Qooooo`03o`000?oooooooooo027ooooo00?o
0000ooooooooool01oooool5o`00023ooooo0ol0000Qooooo`?o00002?ooool5o`0001oooooo0ol0
0003ooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3koooo
o`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006ooo
oooko`0000?ooooo000Kooooo`03o`000?oooooooooo00Gooooo1Ol00003ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool00Oooool001_ooooo00?o0000ooooooooool02_ooool7o`00
01Gooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo
02Oooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo
007ooooo000Kooooo`03o`000?oooooooooo017ooooo0ol0003Wooooo`006oooool00ol0003ooooo
ooooo`0Dooooo`03o`000?oooooooooo0>Cooooo000Kooooo`;o00005_ooool3o`000>?ooooo000K
ooooo`03o`000?oooooooooo01Sooooo0ol0003Pooooo`006oooool00ol0003oooooooooo`0Koooo
o`03o`000?oooooooooo0=gooooo000Kooooo`03o`000?oooooooooo01cooooo0ol0003Looooo`00
6oooool00ol0003oooooooooo`0Oooooo`?o0000fOooool001_ooooo0_l0000Sooooo`03o`000?oo
oooooooo0=Kooooo000Kooooo`03o`000?oooooooooo02?ooooo0_l0003Fooooo`006oooool00ol0
003oooooooooo`0Uooooo`;o0000e?ooool001_ooooo00?o0000ooooooooool09oooool2o`000=;o
oooo000Kooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0coooool001_ooooo00?o
0000ooooooooool0:_ooool2o`000<oooooo000Kooooo`;o0000;Oooool00ol0003oooooooooo`3<
ooooo`006oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo0<_ooooo000Kooooo`03
o`000?oooooooooo02kooooo00?o0000ooooooooool0b_ooool001_ooooo00?o0000ooooooooool0
;oooool00ol0003oooooooooo`39ooooo`006oooool00ol0003oooooooooo`0`ooooo`03o`000?oo
oooooooo0<Sooooo000Kooooo`;o0000<_ooool2o`000<Sooooo000Kooooo`03o`000?oooooooooo
03?ooooo0_l00036ooooo`002?ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Go
oooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`33ooooo`001oooool01?l0003ooooo
ooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0foooo
o`03o`000?oooooooooo0<;ooooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo0<7ooooo0007ooooo`04
o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool00_ooool2o`0003Wooooo0_l00031oooo
o`001oooool01?l0003oooooooooool00007ooooo`Co00001Oooool00ol0003oooooooooo`0joooo
o`03o`000?oooooooooo0;kooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo0;gooooo0008ooooo`;o
00002?ooool5o`0000Cooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`2looooo`00
6oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo0;cooooo000Kooooo`;o0000?_oo
ool00ol0003oooooooooo`2kooooo`006oooool00ol0003oooooooooo`0nooooo`03o`000?oooooo
oooo0;[ooooo000Kooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0^Oooool001_o
oooo00?o0000ooooooooool0@?ooool00ol0003oooooooooo`2hooooo`006oooool00ol0003ooooo
ooooo`11ooooo`03o`000?oooooooooo0;Oooooo000Kooooo`;o0000@oooool00ol0003ooooooooo
o`2fooooo`006oooool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo0;Gooooo000Koooo
o`03o`000?oooooooooo04Cooooo00?o0000ooooooooool0]?ooool001_ooooo00?o0000oooooooo
ool0AOooool00ol0003oooooooooo`2cooooo`006oooool00ol0003oooooooooo`16ooooo`03o`00
0?oooooooooo0;;ooooo000Kooooo`;o0000Aoooool00ol0003oooooooooo`2booooo`006oooool0
0ol0003oooooooooo`17ooooo`03o`000?oooooooooo0;7ooooo000Kooooo`03o`000?oooooooooo
04Sooooo00?o0000ooooooooool0/?ooool001_ooooo00?o0000ooooooooool0BOooool00ol0003o
ooooooooo`2_ooooo`006oooool00ol0003oooooooooo`1:ooooo`03o`000?oooooooooo0:kooooo
000Kooooo`03o`000?oooooooooo04_ooooo00?o0000ooooooooool0[Oooool001_ooooo0_l0001=
ooooo`03o`000?oooooooooo0:cooooo000Kooooo`03o`000?oooooooooo04gooooo00?o0000oooo
ooooool0Zoooool001?ooooo0ol00005ooooo`03o`000?oooooooooo04gooooo00?o0000oooooooo
ool0Zoooool001Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1>ooooo`03o`00
0?oooooooooo0:[ooooo000Dooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0Cooo
ool00ol0003oooooooooo`2Yooooo`005?ooool00ol0003oooooooooo`04ooooo`;o0000DOooool0
0ol0003oooooooooo`2Xooooo`005?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
0?_ooooo000Cooooo`;o00001_ooool00ol0003oooooooooo`3kooooo`005?ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000K
ooooo`;o0000o?ooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000oooooooo
ool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0nooo
ool001_ooooo0_l0003looooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003o
ooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003ooooooooo
o`3kooooo`006oooool2o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03
o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oo
oooooooo0?_ooooo000Kooooo`;o0000o?ooool001_ooooo00?o0000ooooooooool0noooool001_o
oooo00?o0000ooooooooool0noooool000Oooooo0ol00004ooooo`03o`000?oooooooooo00;ooooo
0ol00005ooooo`03o`000?oooooooooo0?_ooooo0008ooooo`03o`000?oooooooooo00Oooooo00Go
0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo0?_ooooo0008ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3kooooo`002?ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo0_l0003looooo`002?ooool00ol0
003oooooooooo`07ooooo`Co00001Oooool00ol0003oooooooooo`3kooooo`001oooool2o`0000Wo
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`3kooooo`002?ooool00ol0003ooooo
ooooo`07ooooo`Go00001?ooool00ol0003oooooooooo`3kooooo`006oooool00ol0003ooooooooo
o`3kooooo`006oooool2o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03
o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oo
oooooooo0?_ooooo000Kooooo`;o0000o?ooool001_ooooo00?o0000ooooooooool0noooool001_o
oooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o
0000ooooooooool0noooool001_ooooo0_l0003looooo`006oooool00ol0003oooooooooo`3koooo
o`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006ooo
ool00ol0003oooooooooo`3kooooo`006oooool2o`000?cooooo000Kooooo`03o`000?oooooooooo
0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Booooo`Go00001?ooool00ol0003ooooo
ooooo`3kooooo`004oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo0?_ooooo
000Dooooo`03o`000?oooooooooo00Cooooo0_l0003looooo`005Oooool00ol0003oooooooooo`3o
ooooo`;ooooo000Booooo`05o`000?ooooooooooooooool00000ooooool3ooooo`004_ooool01Ol0
003ooooooooooooooooo00000?oooooo0oooool001?ooooo0ol0003oooooo`Cooooo003ooooooa[o
oooo003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo0000\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-0.324738, -1.17681, \
0.0119676, 0.019364}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p2 = 
        Plot[g[t], {t, 1.01, 2}, 
          PlotRange \[Rule] {{0, 3}, {\(-1\), 2}}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.333333 0.206011 0.206011 [
[.16667 .19351 -9 -9 ]
[.16667 .19351 9 0 ]
[.33333 .19351 -3 -9 ]
[.33333 .19351 3 0 ]
[.5 .19351 -9 -9 ]
[.5 .19351 9 0 ]
[.66667 .19351 -3 -9 ]
[.66667 .19351 3 0 ]
[.83333 .19351 -9 -9 ]
[.83333 .19351 9 0 ]
[1 .19351 -3 -9 ]
[1 .19351 3 0 ]
[-0.0125 0 -12 -4.5 ]
[-0.0125 0 0 4.5 ]
[-0.0125 .10301 -24 -4.5 ]
[-0.0125 .10301 0 4.5 ]
[-0.0125 .30902 -18 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .41202 -6 -4.5 ]
[-0.0125 .41202 0 4.5 ]
[-0.0125 .51503 -18 -4.5 ]
[-0.0125 .51503 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16667 .20601 m
.16667 .21226 L
s
[(0.5)] .16667 .19351 0 1 Mshowa
.33333 .20601 m
.33333 .21226 L
s
[(1)] .33333 .19351 0 1 Mshowa
.5 .20601 m
.5 .21226 L
s
[(1.5)] .5 .19351 0 1 Mshowa
.66667 .20601 m
.66667 .21226 L
s
[(2)] .66667 .19351 0 1 Mshowa
.83333 .20601 m
.83333 .21226 L
s
[(2.5)] .83333 .19351 0 1 Mshowa
1 .20601 m
1 .21226 L
s
[(3)] 1 .19351 0 1 Mshowa
.125 Mabswid
.03333 .20601 m
.03333 .20976 L
s
.06667 .20601 m
.06667 .20976 L
s
.1 .20601 m
.1 .20976 L
s
.13333 .20601 m
.13333 .20976 L
s
.2 .20601 m
.2 .20976 L
s
.23333 .20601 m
.23333 .20976 L
s
.26667 .20601 m
.26667 .20976 L
s
.3 .20601 m
.3 .20976 L
s
.36667 .20601 m
.36667 .20976 L
s
.4 .20601 m
.4 .20976 L
s
.43333 .20601 m
.43333 .20976 L
s
.46667 .20601 m
.46667 .20976 L
s
.53333 .20601 m
.53333 .20976 L
s
.56667 .20601 m
.56667 .20976 L
s
.6 .20601 m
.6 .20976 L
s
.63333 .20601 m
.63333 .20976 L
s
.7 .20601 m
.7 .20976 L
s
.73333 .20601 m
.73333 .20976 L
s
.76667 .20601 m
.76667 .20976 L
s
.8 .20601 m
.8 .20976 L
s
.86667 .20601 m
.86667 .20976 L
s
.9 .20601 m
.9 .20976 L
s
.93333 .20601 m
.93333 .20976 L
s
.96667 .20601 m
.96667 .20976 L
s
.25 Mabswid
0 .20601 m
1 .20601 L
s
0 0 m
.00625 0 L
s
[(-1)] -0.0125 0 1 0 Mshowa
0 .10301 m
.00625 .10301 L
s
[(-0.5)] -0.0125 .10301 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0.5)] -0.0125 .30902 1 0 Mshowa
0 .41202 m
.00625 .41202 L
s
[(1)] -0.0125 .41202 1 0 Mshowa
0 .51503 m
.00625 .51503 L
s
[(1.5)] -0.0125 .51503 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(2)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0206 m
.00375 .0206 L
s
0 .0412 m
.00375 .0412 L
s
0 .0618 m
.00375 .0618 L
s
0 .0824 m
.00375 .0824 L
s
0 .12361 m
.00375 .12361 L
s
0 .14421 m
.00375 .14421 L
s
0 .16481 m
.00375 .16481 L
s
0 .18541 m
.00375 .18541 L
s
0 .22661 m
.00375 .22661 L
s
0 .24721 m
.00375 .24721 L
s
0 .26781 m
.00375 .26781 L
s
0 .28842 m
.00375 .28842 L
s
0 .32962 m
.00375 .32962 L
s
0 .35022 m
.00375 .35022 L
s
0 .37082 m
.00375 .37082 L
s
0 .39142 m
.00375 .39142 L
s
0 .43262 m
.00375 .43262 L
s
0 .45322 m
.00375 .45322 L
s
0 .47383 m
.00375 .47383 L
s
0 .49443 m
.00375 .49443 L
s
0 .53563 m
.00375 .53563 L
s
0 .55623 m
.00375 .55623 L
s
0 .57683 m
.00375 .57683 L
s
0 .59743 m
.00375 .59743 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.33667 .23074 m
.35005 .22686 L
.36465 .22299 L
.37837 .21973 L
.39155 .21691 L
.40559 .21427 L
.4191 .21208 L
.43346 .21012 L
.4473 .20859 L
.46061 .20745 L
.46748 .20699 L
.47477 .2066 L
.47803 .20646 L
.48154 .20633 L
.48482 .20622 L
.48788 .20615 L
.49138 .20608 L
.49323 .20605 L
.49417 .20604 L
.4952 .20603 L
.49618 .20602 L
.49708 .20602 L
.49794 .20602 L
.49837 .20601 L
.49862 .20601 L
.49885 .20601 L
.49928 .20601 L
.49968 .20601 L
.5001 .20601 L
.50034 .20601 L
.50056 .20601 L
.50093 .20601 L
.50134 .20601 L
.50176 .20601 L
.50216 .20602 L
.503 .20602 L
.50379 .20602 L
.50557 .20604 L
.5073 .20606 L
.50915 .20609 L
.51251 .20616 L
.51557 .20624 L
.52221 .20647 L
.52942 .20681 L
.5436 .20777 L
.55725 .20905 L
.57038 .2106 L
.58436 .21261 L
.59781 .21488 L
.61211 .21766 L
Mistroke
.62589 .2207 L
.63914 .22396 L
.65324 .22778 L
.66667 .23176 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`00oooooolJooooo`004oooool3o`000?oooooo1?ooool001Cooooo00?o0000ooooooooool0
ooooool3ooooo`003?ooool5o`0000?ooooo00?o0000ooooooooool01?ooool2o`000?cooooo000D
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0noooool001Cooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`3kooooo`004oooool2o`0000Kooooo00?o0000oooooooo
ool0noooool001Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3kooooo`006ooo
ool00ol0003oooooooooo`3kooooo`006oooool2o`000?cooooo000Kooooo`03o`000?oooooooooo
0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo
000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`;o0000o?ooool001_ooooo00?o0000oooo
ooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0
noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo0_l0003looooo`006oooool00ol0
003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003ooooo
ooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool2o`000?cooooo000Koooo
o`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo0008ooooo`;o0000
1?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`3kooooo`001ooo
ool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003o
ooooooooo`3kooooo`001Ol00002ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000oooooooo
ool00_ooool2o`000?cooooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`3kooooo`001oooool01?l0003oooooooooool00007ooooo`Co
00001Oooool00ol0003oooooooooo`3kooooo`001oooool01?l0003oooooooooool00007ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool0noooool000Sooooo0_l00008ooooo`Go0000
1?ooool00ol0003oooooooooo`3kooooo`006oooool2o`000?cooooo000Kooooo`03o`000?oooooo
oooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_o
oooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000K
ooooo`;o0000o?ooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000oooooooo
ool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool07ooo
ool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`00027ooooo0ol0000Qooooo`?o00001?oo
ool00ol0003oooooooooo`02ooooo`?o00008?ooool5o`0001oooooo1Ol00003ooooo`03o`000?oo
oooooooo00;ooooo0ol0000Pooooo`?o00000oooool001_ooooo0_l0000Oooooo`04o`000?oooooo
ooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Qooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo0000023ooooo00Co0000oooooooo
oooo00008?ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000007_oo
ool01Ol0003ooooooooooooooooo000000;ooooo000Kooooo`03o`000?oooooooooo01kooooo00Co
0000oooooooooooo00002oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0Pooooo`7o00000Oooool1ooooo`006ooo
ool00ol0003oooooooooo`0Nooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool0
7oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
8?ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
7_ooool2o`0000?ooooo000Kooooo`03o`000?oooooooooo01kooooo00Co0000oooooooooooo0000
1oooool4o`0002;ooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`07ooooo`Co0000
8?ooool01Ol0003ooooooooooooooooo000001oooooo00Go0000ooooooooooooooooo`000007oooo
o`Co00008oooool1o`00007ooooo0Oooool001_ooooo00?o0000ooooooooool07_ooool01?l0003o
ooooooooool00007ooooo`03o`000?oooooooooo02;ooooo0_l0000Rooooo`;o00002Oooool00ol0
003oooooooooo`0Qooooo`05o`000?ooooooooooooooool000007oooool01Ol0003ooooooooooooo
oooo000000Oooooo00?o0000ooooooooool08?ooool01Ol0003ooooooooooooooooo000000;ooooo
000Kooooo`;o00008?ooool2o`0000Sooooo1Ol0000Qooooo`03o`000?oooooooooo027ooooo00?o
0000ooooooooool01oooool5o`00023ooooo0ol0000Qooooo`?o00002?ooool5o`0001oooooo0ol0
0003ooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3koooo
o`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006ooo
oooko`0000?ooooo000Kooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo1ol00003ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooo`00000:o`0000Cooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool00Oooool001_ooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`0Woooo
o`03o`000?oooooooooo00kooooo1ol0000Booooo`03o`000?oooooooooo01;ooooo1_l0000?oooo
o`03o`000?oooooooooo02Oooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`01oooo
o`006oooool00ol0003oooooooooo`1Mooooo`Co0000=?ooool4o`0006;ooooo000Kooooo`03o`00
0?oooooooooo05Kooooo1ol0000looooo`Co0000G_ooool001_ooooo0_l0001Dooooo`?o0000Aooo
ool3o`0005_ooooo000Kooooo`03o`000?oooooooooo057ooooo0_l0001=ooooo`?o0000F?ooool0
01_ooooo00?o0000ooooooooool0Xoooool2o`0005Kooooo000Kooooo`03o`000?oooooooooo0?_o
oooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`;o0000o?ooool001_ooooo00?o0000
ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000oooooooo
ool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0nooo
ool001_ooooo0_l0003looooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003o
ooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003ooooooooo
o`3kooooo`006oooool2o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo0008ooooo`;o
00001?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`3kooooo`00
1oooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0
003oooooooooo`3kooooo`001oooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool0noooool000Oooooo00Co0000oooooooooooo00002oooool00ol0
003oooooooooo`02ooooo`;o0000o?ooool000Oooooo00Co0000oooooooooooo00001oooool4o`00
00Gooooo00?o0000ooooooooool0noooool000Oooooo00Co0000oooooooooooo00001oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo0?_ooooo0008ooooo`;o00002?ooool5o`0000Co
oooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo0_l0
003looooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3koooo
o`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006ooo
ool2o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo
0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo
000Kooooo`;o0000o?ooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000oooo
ooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0
noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo0_l0003looooo`006oooool00ol0
003oooooooooo`3kooooo`004oooool3o`0000Gooooo00?o0000ooooooooool0noooool001Cooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`3kooooo`005?ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo0?_ooooo000Dooooo`03o`000?oooooooooo00Cooooo0_l0003l
ooooo`005?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0?_ooooo000Cooooo`;o
00001_ooool00ol0003oooooooooo`3kooooo`005?ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`;o0000o?ooool0
01_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo
00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo0_l0003l
ooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`00
6oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool2
o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_o
oooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000K
ooooo`;o0000o?ooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000oooooooo
ool0noooool000Oooooo0ol00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`00
0?oooooooooo0?_ooooo0008ooooo`03o`000?oooooooooo00Oooooo00Go0000oooooooooooooooo
o`000004ooooo`03o`000?oooooooooo0?_ooooo0008ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`3kooooo`002?ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00;ooooo0_l0003looooo`002?ooool00ol0003oooooooooo`07oooo
o`Co00001Oooool00ol0003oooooooooo`3kooooo`001oooool2o`0000Wooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`3kooooo`002?ooool00ol0003oooooooooo`07ooooo`Go0000
1?ooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool2
o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_o
oooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000K
ooooo`;o0000o?ooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000oooooooo
ool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0nooo
ool001_ooooo0_l0003looooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003o
ooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003ooooooooo
o`3kooooo`006oooool2o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03
o`000?oooooooooo0?_ooooo000Booooo`Go00001?ooool00ol0003oooooooooo`3kooooo`004ooo
ool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo0?_ooooo000Dooooo`03o`000?oo
oooooooo00Cooooo0_l0003looooo`005Oooool00ol0003oooooooooo`3oooooo`;ooooo000Boooo
o`05o`000?ooooooooooooooool00000ooooool3ooooo`004_ooool01Ol0003ooooooooooooooooo
00000?oooooo0oooool001?ooooo0ol0003oooooo`Cooooo003ooooooa[ooooo003ooooooa[ooooo
003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo0000\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-0.324738, -1.17681, \
0.0119676, 0.019364}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p3 = 
        Plot[g[t], {t, 2.01, 3}, 
          PlotRange \[Rule] {{0, 3}, {\(-1\), 2}}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.333333 0.206011 0.206011 [
[.16667 .19351 -9 -9 ]
[.16667 .19351 9 0 ]
[.33333 .19351 -3 -9 ]
[.33333 .19351 3 0 ]
[.5 .19351 -9 -9 ]
[.5 .19351 9 0 ]
[.66667 .19351 -3 -9 ]
[.66667 .19351 3 0 ]
[.83333 .19351 -9 -9 ]
[.83333 .19351 9 0 ]
[1 .19351 -3 -9 ]
[1 .19351 3 0 ]
[-0.0125 0 -12 -4.5 ]
[-0.0125 0 0 4.5 ]
[-0.0125 .10301 -24 -4.5 ]
[-0.0125 .10301 0 4.5 ]
[-0.0125 .30902 -18 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .41202 -6 -4.5 ]
[-0.0125 .41202 0 4.5 ]
[-0.0125 .51503 -18 -4.5 ]
[-0.0125 .51503 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16667 .20601 m
.16667 .21226 L
s
[(0.5)] .16667 .19351 0 1 Mshowa
.33333 .20601 m
.33333 .21226 L
s
[(1)] .33333 .19351 0 1 Mshowa
.5 .20601 m
.5 .21226 L
s
[(1.5)] .5 .19351 0 1 Mshowa
.66667 .20601 m
.66667 .21226 L
s
[(2)] .66667 .19351 0 1 Mshowa
.83333 .20601 m
.83333 .21226 L
s
[(2.5)] .83333 .19351 0 1 Mshowa
1 .20601 m
1 .21226 L
s
[(3)] 1 .19351 0 1 Mshowa
.125 Mabswid
.03333 .20601 m
.03333 .20976 L
s
.06667 .20601 m
.06667 .20976 L
s
.1 .20601 m
.1 .20976 L
s
.13333 .20601 m
.13333 .20976 L
s
.2 .20601 m
.2 .20976 L
s
.23333 .20601 m
.23333 .20976 L
s
.26667 .20601 m
.26667 .20976 L
s
.3 .20601 m
.3 .20976 L
s
.36667 .20601 m
.36667 .20976 L
s
.4 .20601 m
.4 .20976 L
s
.43333 .20601 m
.43333 .20976 L
s
.46667 .20601 m
.46667 .20976 L
s
.53333 .20601 m
.53333 .20976 L
s
.56667 .20601 m
.56667 .20976 L
s
.6 .20601 m
.6 .20976 L
s
.63333 .20601 m
.63333 .20976 L
s
.7 .20601 m
.7 .20976 L
s
.73333 .20601 m
.73333 .20976 L
s
.76667 .20601 m
.76667 .20976 L
s
.8 .20601 m
.8 .20976 L
s
.86667 .20601 m
.86667 .20976 L
s
.9 .20601 m
.9 .20976 L
s
.93333 .20601 m
.93333 .20976 L
s
.96667 .20601 m
.96667 .20976 L
s
.25 Mabswid
0 .20601 m
1 .20601 L
s
0 0 m
.00625 0 L
s
[(-1)] -0.0125 0 1 0 Mshowa
0 .10301 m
.00625 .10301 L
s
[(-0.5)] -0.0125 .10301 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0.5)] -0.0125 .30902 1 0 Mshowa
0 .41202 m
.00625 .41202 L
s
[(1)] -0.0125 .41202 1 0 Mshowa
0 .51503 m
.00625 .51503 L
s
[(1.5)] -0.0125 .51503 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(2)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0206 m
.00375 .0206 L
s
0 .0412 m
.00375 .0412 L
s
0 .0618 m
.00375 .0618 L
s
0 .0824 m
.00375 .0824 L
s
0 .12361 m
.00375 .12361 L
s
0 .14421 m
.00375 .14421 L
s
0 .16481 m
.00375 .16481 L
s
0 .18541 m
.00375 .18541 L
s
0 .22661 m
.00375 .22661 L
s
0 .24721 m
.00375 .24721 L
s
0 .26781 m
.00375 .26781 L
s
0 .28842 m
.00375 .28842 L
s
0 .32962 m
.00375 .32962 L
s
0 .35022 m
.00375 .35022 L
s
0 .37082 m
.00375 .37082 L
s
0 .39142 m
.00375 .39142 L
s
0 .43262 m
.00375 .43262 L
s
0 .45322 m
.00375 .45322 L
s
0 .47383 m
.00375 .47383 L
s
0 .49443 m
.00375 .49443 L
s
0 .53563 m
.00375 .53563 L
s
0 .55623 m
.00375 .55623 L
s
0 .57683 m
.00375 .57683 L
s
0 .59743 m
.00375 .59743 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.67 .60977 m
.68339 .57618 L
.69799 .53879 L
.7117 .50295 L
.72489 .46783 L
.73892 .42973 L
.75243 .39237 L
.76679 .35192 L
.78063 .31222 L
.79394 .27336 L
.8081 .2313 L
.82173 .1901 L
.83484 .14983 L
.8488 .10626 L
.86224 .06364 L
.87652 .01759 L
s
.87652 .01759 m
.88189 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`00oooooolJooooo`004oooool3o`000?oooooo1?ooool001Cooooo00?o0000ooooooooool0
ooooool3ooooo`003?ooool5o`0000?ooooo00?o0000ooooooooool01?ooool2o`000=_ooooo00?o
0000ooooooooool07_ooool001Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3J
ooooo`03o`000?oooooooooo01kooooo000Dooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0fOooool00ol0003oooooooooo`0Oooooo`004oooool2o`0000Kooooo00?o0000oooooooo
ool0fOooool00ol0003oooooooooo`0Oooooo`005?ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo0=Wooooo00?o0000ooooooooool07oooool001_ooooo00?o0000ooooooooool0f?oo
ool00ol0003oooooooooo`0Pooooo`006oooool2o`000=Wooooo00?o0000ooooooooool08?ooool0
01_ooooo00?o0000ooooooooool0f?ooool00ol0003oooooooooo`0Pooooo`006oooool00ol0003o
ooooooooo`3Gooooo`03o`000?oooooooooo027ooooo000Kooooo`03o`000?oooooooooo0=Oooooo
00?o0000ooooooooool08Oooool001_ooooo00?o0000ooooooooool0eoooool00ol0003ooooooooo
o`0Qooooo`006oooool2o`000=Oooooo00?o0000ooooooooool08_ooool001_ooooo00?o0000oooo
ooooool0e_ooool00ol0003oooooooooo`0Rooooo`006oooool00ol0003oooooooooo`3Fooooo`03
o`000?oooooooooo02;ooooo000Kooooo`03o`000?oooooooooo0=Kooooo00?o0000ooooooooool0
8_ooool001_ooooo00?o0000ooooooooool0eOooool00ol0003oooooooooo`0Sooooo`006oooool2
o`000=Kooooo00?o0000ooooooooool08oooool001_ooooo00?o0000ooooooooool0eOooool00ol0
003oooooooooo`0Sooooo`006oooool00ol0003oooooooooo`3Dooooo`03o`000?oooooooooo02Co
oooo000Kooooo`03o`000?oooooooooo0=Cooooo00?o0000ooooooooool09?ooool001_ooooo00?o
0000ooooooooool0e?ooool00ol0003oooooooooo`0Tooooo`006oooool2o`000=Cooooo00?o0000
ooooooooool09Oooool001_ooooo00?o0000ooooooooool0doooool00ol0003oooooooooo`0Uoooo
o`006oooool00ol0003oooooooooo`3Cooooo`03o`000?oooooooooo02Gooooo0008ooooo`;o0000
1?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`3Booooo`03o`00
0?oooooooooo02Kooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooooooo
ooooo`000004ooooo`03o`000?oooooooooo0=;ooooo00?o0000ooooooooool09_ooool000Go0000
0_ooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo00;ooooo0_l0003Cooooo`03
o`000?oooooooooo02Kooooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`3Aooooo`03o`000?oooooooooo02Oooooo0007ooooo`04o`00
0?ooooooooooo`0000Oooooo1?l00005ooooo`03o`000?oooooooooo0=7ooooo00?o0000oooooooo
ool09oooool000Oooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo0=7ooooo00?o0000ooooooooool09oooool000Sooooo0_l00008ooooo`Go0000
1?ooool00ol0003oooooooooo`3@ooooo`03o`000?oooooooooo02Sooooo000Kooooo`;o0000dOoo
ool00ol0003oooooooooo`0Xooooo`006oooool00ol0003oooooooooo`3@ooooo`03o`000?oooooo
oooo02Sooooo000Kooooo`03o`000?oooooooooo0<oooooo00?o0000ooooooooool0:Oooool001_o
oooo00?o0000ooooooooool0coooool00ol0003oooooooooo`0Yooooo`006oooool00ol0003ooooo
ooooo`3?ooooo`03o`000?oooooooooo02Wooooo000Kooooo`03o`000?oooooooooo0<oooooo00?o
0000ooooooooool0:Oooool001_ooooo0_l0003?ooooo`03o`000?oooooooooo02[ooooo000Koooo
o`03o`000?oooooooooo0<kooooo00?o0000ooooooooool0:_ooool001_ooooo00?o0000oooooooo
ool0c_ooool00ol0003oooooooooo`0Zooooo`006oooool00ol0003oooooooooo`3>ooooo`03o`00
0?oooooooooo02[ooooo000Kooooo`03o`000?oooooooooo01oooooo0_l00004ooooo`03o`000?oo
oooooooo00;ooooo0ol0000Qooooo`?o00008Oooool3o`0000Cooooo00?o0000ooooooooool00_oo
ool3o`00023ooooo1Ol0000Oooooo`Go00000oooool00ol0003oooooooooo`02ooooo`?o00008?oo
ool3o`0000?ooooo000Kooooo`;o00007oooool01?l0003oooooooooool00007ooooo`05o`000?oo
ooooooooooooool000008Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00Oooooo
00Go0000ooooooooooooooooo`00000Pooooo`04o`000?ooooooooooo`00023ooooo00Co0000oooo
oooooooo00000oooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool07?oo
ool01Ol0003ooooooooooooooooo000000;ooooo000Kooooo`03o`000?oooooooooo01kooooo00Co
0000oooooooooooo00002oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo023ooooo
0Ol00001ooooo`7ooooo000Kooooo`03o`000?oooooooooo01kooooo00Co0000oooooooooooo0000
2oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo027ooooo00Go0000oooooooooooo
ooooo`000008ooooo`03o`000?oooooooooo01kooooo0_l00003ooooo`006oooool00ol0003ooooo
ooooo`0Nooooo`04o`000?ooooooooooo`0000Oooooo1?l0000Rooooo`03o`000?oooooooooo027o
oooo00?o0000ooooooooool01oooool4o`00023ooooo00Go0000ooooooooooooooooo`00000Ooooo
o`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`02ooooo`Co00008oooool1
o`00007ooooo0Oooool001_ooooo00?o0000ooooooooool07_ooool01?l0003oooooooooool00007
ooooo`03o`000?oooooooooo02;ooooo0_l0000Rooooo`;o00002Oooool00ol0003oooooooooo`0Q
ooooo`05o`000?ooooooooooooooool000007oooool01Ol0003ooooooooooooooooo000000;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Pooooo`05o`000?ooooooooooooooool0
00000_ooool001_ooooo0_l0000Pooooo`;o00002?ooool5o`00027ooooo00?o0000ooooooooool0
8Oooool00ol0003oooooooooo`07ooooo`Go00008?ooool3o`00027ooooo0ol00002ooooo`03o`00
0?oooooooooo00?ooooo1Ol0000Oooooo`?o00000oooool001_ooooo00?o0000ooooooooool0booo
ool00ol0003oooooooooo`0]ooooo`006oooool00ol0003oooooooooo`3;ooooo`03o`000?oooooo
oooo02gooooo000Kooooo`03o`000?oooooooooo0<[ooooo00?o0000ooooooooool0;_ooool001_o
oooo00?o0000ooooooooool0b_ooool00ol0003oooooooooo`0^ooooo`006ooooooko`0000?ooooo
000Kooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`05ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool00Oooool001_ooooo00?o0000ooooooooool09_oo
ool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool09ooo
ool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool09_oo
ool00ol0003oooooooooo`01ooooo`006oooool00ol0003oooooooooo`38ooooo`03o`000?oooooo
oooo033ooooo000Kooooo`03o`000?oooooooooo0<Sooooo00?o0000ooooooooool0<?ooool001_o
oooo0_l00039ooooo`03o`000?oooooooooo033ooooo000Kooooo`03o`000?oooooooooo0<Oooooo
00?o0000ooooooooool0<Oooool001_ooooo00?o0000ooooooooool0aoooool00ol0003ooooooooo
o`0aooooo`006oooool00ol0003oooooooooo`37ooooo`03o`000?oooooooooo037ooooo000Koooo
o`03o`000?oooooooooo0<Kooooo00?o0000ooooooooool0<_ooool001_ooooo0_l00037ooooo`03
o`000?oooooooooo03;ooooo000Kooooo`03o`000?oooooooooo0<Kooooo00?o0000ooooooooool0
<_ooool001_ooooo00?o0000ooooooooool0aOooool00ol0003oooooooooo`0cooooo`006oooool0
0ol0003oooooooooo`35ooooo`03o`000?oooooooooo03?ooooo000Kooooo`03o`000?oooooooooo
0<Gooooo00?o0000ooooooooool0<oooool001_ooooo00?o0000ooooooooool0aOooool00ol0003o
ooooooooo`0cooooo`006oooool2o`000<Gooooo00?o0000ooooooooool0=?ooool001_ooooo00?o
0000ooooooooool0a?ooool00ol0003oooooooooo`0dooooo`006oooool00ol0003oooooooooo`34
ooooo`03o`000?oooooooooo03Cooooo000Kooooo`03o`000?oooooooooo0<?ooooo00?o0000oooo
ooooool0=Oooool001_ooooo00?o0000ooooooooool0`oooool00ol0003oooooooooo`0eooooo`00
6oooool2o`000<Cooooo00?o0000ooooooooool0=Oooool001_ooooo00?o0000ooooooooool0`_oo
ool00ol0003oooooooooo`0fooooo`002?ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3
o`0000Gooooo00?o0000ooooooooool0`_ooool00ol0003oooooooooo`0fooooo`001oooool01?l0
003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooooooo
o`31ooooo`03o`000?oooooooooo03Oooooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`31ooooo`03o`000?oooooooooo03Oooooo0007
ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool00_ooool2o`000<;ooooo00?o
0000ooooooooool0=oooool000Oooooo00Co0000oooooooooooo00001oooool4o`0000Gooooo00?o
0000ooooooooool0`?ooool00ol0003oooooooooo`0hooooo`001oooool01?l0003oooooooooool0
0007ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0`?ooool00ol0003ooooooooo
o`0hooooo`002?ooool2o`0000Sooooo1Ol00004ooooo`03o`000?oooooooooo0<3ooooo00?o0000
ooooooooool0>?ooool001_ooooo00?o0000ooooooooool0_oooool00ol0003oooooooooo`0ioooo
o`006oooool2o`000<3ooooo00?o0000ooooooooool0>Oooool001_ooooo00?o0000ooooooooool0
_oooool00ol0003oooooooooo`0iooooo`006oooool00ol0003oooooooooo`2nooooo`03o`000?oo
oooooooo03[ooooo000Kooooo`03o`000?oooooooooo0;kooooo00?o0000ooooooooool0>_ooool0
01_ooooo00?o0000ooooooooool0__ooool00ol0003oooooooooo`0jooooo`006oooool2o`000;ko
oooo00?o0000ooooooooool0>oooool001_ooooo00?o0000ooooooooool0_Oooool00ol0003ooooo
ooooo`0kooooo`006oooool00ol0003oooooooooo`2mooooo`03o`000?oooooooooo03_ooooo000K
ooooo`03o`000?oooooooooo0;cooooo00?o0000ooooooooool0??ooool001_ooooo00?o0000oooo
ooooool0_?ooool00ol0003oooooooooo`0looooo`006oooool2o`000;gooooo00?o0000oooooooo
ool0??ooool001_ooooo00?o0000ooooooooool0^oooool00ol0003oooooooooo`0mooooo`006ooo
ool00ol0003oooooooooo`2kooooo`03o`000?oooooooooo03gooooo000Kooooo`03o`000?oooooo
oooo0;[ooooo00?o0000ooooooooool0?_ooool001_ooooo00?o0000ooooooooool0^_ooool00ol0
003oooooooooo`0nooooo`006oooool00ol0003oooooooooo`2jooooo`03o`000?oooooooooo03ko
oooo000Kooooo`;o0000^_ooool00ol0003oooooooooo`0oooooo`006oooool00ol0003ooooooooo
o`2iooooo`03o`000?oooooooooo03oooooo000Cooooo`?o00001Oooool00ol0003oooooooooo`2h
ooooo`03o`000?oooooooooo043ooooo000Dooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0^?ooool00ol0003oooooooooo`10ooooo`005?ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo0;Sooooo00?o0000ooooooooool0@?ooool001Cooooo00?o0000ooooooooool0
1?ooool2o`000;Sooooo00?o0000ooooooooool0@Oooool001Cooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`2gooooo`03o`000?oooooooooo047ooooo000Cooooo`;o00001_ooool0
0ol0003oooooooooo`2gooooo`03o`000?oooooooooo047ooooo000Dooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool0]_ooool00ol0003oooooooooo`12ooooo`006oooool00ol0003o
ooooooooo`2fooooo`03o`000?oooooooooo04;ooooo000Kooooo`;o0000]oooool00ol0003ooooo
ooooo`12ooooo`006oooool00ol0003oooooooooo`2eooooo`03o`000?oooooooooo04?ooooo000K
ooooo`03o`000?oooooooooo0;Gooooo00?o0000ooooooooool0@oooool001_ooooo00?o0000oooo
ooooool0]Oooool00ol0003oooooooooo`13ooooo`006oooool00ol0003oooooooooo`2dooooo`03
o`000?oooooooooo04Cooooo000Kooooo`;o0000]Oooool00ol0003oooooooooo`14ooooo`006ooo
ool00ol0003oooooooooo`2cooooo`03o`000?oooooooooo04Gooooo000Kooooo`03o`000?oooooo
oooo0;?ooooo00?o0000ooooooooool0AOooool001_ooooo00?o0000ooooooooool0/oooool00ol0
003oooooooooo`15ooooo`006oooool00ol0003oooooooooo`2booooo`03o`000?oooooooooo04Ko
oooo000Kooooo`;o0000/oooool00ol0003oooooooooo`16ooooo`006oooool00ol0003ooooooooo
o`2aooooo`03o`000?oooooooooo04Oooooo000Kooooo`03o`000?oooooooooo0;7ooooo00?o0000
ooooooooool0Aoooool001_ooooo00?o0000ooooooooool0/Oooool00ol0003oooooooooo`17oooo
o`006oooool00ol0003oooooooooo`2`ooooo`03o`000?oooooooooo04Sooooo000Kooooo`;o0000
/Oooool00ol0003oooooooooo`18ooooo`006oooool00ol0003oooooooooo`2`ooooo`03o`000?oo
oooooooo04Sooooo000Kooooo`03o`000?oooooooooo0:oooooo00?o0000ooooooooool0BOooool0
00Oooooo0ol00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?oooooooooo
0:oooooo00?o0000ooooooooool0BOooool000Sooooo00?o0000ooooooooool01oooool01Ol0003o
oooooooooooooooo000000Cooooo00?o0000ooooooooool0[oooool00ol0003oooooooooo`19oooo
o`002?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0[_ooool00ol0003oooooooooo`1:ooooo`002?ooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo00;ooooo0_l0002_ooooo`03o`000?oooooooooo04[ooooo0008ooooo`03o`000?oo
oooooooo00Oooooo1?l00005ooooo`03o`000?oooooooooo0:kooooo00?o0000ooooooooool0B_oo
ool000Oooooo0_l00009ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0[Oooool0
0ol0003oooooooooo`1;ooooo`002?ooool00ol0003oooooooooo`07ooooo`Go00001?ooool00ol0
003oooooooooo`2]ooooo`03o`000?oooooooooo04_ooooo000Kooooo`03o`000?oooooooooo0:go
oooo00?o0000ooooooooool0Boooool001_ooooo0_l0002]ooooo`03o`000?oooooooooo04cooooo
000Kooooo`03o`000?oooooooooo0:cooooo00?o0000ooooooooool0C?ooool001_ooooo00?o0000
ooooooooool0[?ooool00ol0003oooooooooo`1<ooooo`006oooool00ol0003oooooooooo`2[oooo
o`03o`000?oooooooooo04gooooo000Kooooo`03o`000?oooooooooo0:_ooooo00?o0000oooooooo
ool0COooool001_ooooo0_l0002[ooooo`03o`000?oooooooooo04kooooo000Kooooo`03o`000?oo
oooooooo0:[ooooo00?o0000ooooooooool0C_ooool001_ooooo00?o0000ooooooooool0Z_ooool0
0ol0003oooooooooo`1>ooooo`006oooool00ol0003oooooooooo`2Yooooo`03o`000?oooooooooo
04oooooo000Kooooo`03o`000?oooooooooo0:Wooooo00?o0000ooooooooool0Coooool001_ooooo
0_l0002Yooooo`03o`000?oooooooooo053ooooo000Kooooo`03o`000?oooooooooo0:Sooooo00?o
0000ooooooooool0D?ooool001_ooooo00?o0000ooooooooool0Yoooool00ol0003oooooooooo`1A
ooooo`006oooool00ol0003oooooooooo`2Wooooo`03o`000?oooooooooo057ooooo000Kooooo`03
o`000?oooooooooo0:Oooooo00?o0000ooooooooool0DOooool001_ooooo0_l0002Wooooo`03o`00
0?oooooooooo05;ooooo000Kooooo`03o`000?oooooooooo0:Kooooo00?o0000ooooooooool0D_oo
ool001_ooooo00?o0000ooooooooool0Y_ooool00ol0003oooooooooo`1Booooo`004_ooool5o`00
00Cooooo00?o0000ooooooooool0YOooool00ol0003oooooooooo`1Cooooo`004oooool01?l0003o
ooooooooool00004ooooo`03o`000?oooooooooo0?_ooooo000Dooooo`03o`000?oooooooooo00Co
oooo0_l0003looooo`005Oooool00ol0003oooooooooo`3oooooo`;ooooo000Booooo`05o`000?oo
ooooooooooooool00000ooooool3ooooo`004_ooool01Ol0003ooooooooooooooooo00000?oooooo
0oooool001?ooooo0ol0003oooooo`Cooooo003ooooooa[ooooo003ooooooa[ooooo003ooooooa[o
oooo003ooooooa[ooooo003ooooooa[ooooo0000\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-0.324738, -1.17681, \
0.0119676, 0.019364}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p4 = Show[p1, p2, p3];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.333333 0.206011 0.206011 [
[.16667 .19351 -9 -9 ]
[.16667 .19351 9 0 ]
[.33333 .19351 -3 -9 ]
[.33333 .19351 3 0 ]
[.5 .19351 -9 -9 ]
[.5 .19351 9 0 ]
[.66667 .19351 -3 -9 ]
[.66667 .19351 3 0 ]
[.83333 .19351 -9 -9 ]
[.83333 .19351 9 0 ]
[1 .19351 -3 -9 ]
[1 .19351 3 0 ]
[-0.0125 0 -12 -4.5 ]
[-0.0125 0 0 4.5 ]
[-0.0125 .10301 -24 -4.5 ]
[-0.0125 .10301 0 4.5 ]
[-0.0125 .30902 -18 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .41202 -6 -4.5 ]
[-0.0125 .41202 0 4.5 ]
[-0.0125 .51503 -18 -4.5 ]
[-0.0125 .51503 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16667 .20601 m
.16667 .21226 L
s
[(0.5)] .16667 .19351 0 1 Mshowa
.33333 .20601 m
.33333 .21226 L
s
[(1)] .33333 .19351 0 1 Mshowa
.5 .20601 m
.5 .21226 L
s
[(1.5)] .5 .19351 0 1 Mshowa
.66667 .20601 m
.66667 .21226 L
s
[(2)] .66667 .19351 0 1 Mshowa
.83333 .20601 m
.83333 .21226 L
s
[(2.5)] .83333 .19351 0 1 Mshowa
1 .20601 m
1 .21226 L
s
[(3)] 1 .19351 0 1 Mshowa
.125 Mabswid
.03333 .20601 m
.03333 .20976 L
s
.06667 .20601 m
.06667 .20976 L
s
.1 .20601 m
.1 .20976 L
s
.13333 .20601 m
.13333 .20976 L
s
.2 .20601 m
.2 .20976 L
s
.23333 .20601 m
.23333 .20976 L
s
.26667 .20601 m
.26667 .20976 L
s
.3 .20601 m
.3 .20976 L
s
.36667 .20601 m
.36667 .20976 L
s
.4 .20601 m
.4 .20976 L
s
.43333 .20601 m
.43333 .20976 L
s
.46667 .20601 m
.46667 .20976 L
s
.53333 .20601 m
.53333 .20976 L
s
.56667 .20601 m
.56667 .20976 L
s
.6 .20601 m
.6 .20976 L
s
.63333 .20601 m
.63333 .20976 L
s
.7 .20601 m
.7 .20976 L
s
.73333 .20601 m
.73333 .20976 L
s
.76667 .20601 m
.76667 .20976 L
s
.8 .20601 m
.8 .20976 L
s
.86667 .20601 m
.86667 .20976 L
s
.9 .20601 m
.9 .20976 L
s
.93333 .20601 m
.93333 .20976 L
s
.96667 .20601 m
.96667 .20976 L
s
.25 Mabswid
0 .20601 m
1 .20601 L
s
0 0 m
.00625 0 L
s
[(-1)] -0.0125 0 1 0 Mshowa
0 .10301 m
.00625 .10301 L
s
[(-0.5)] -0.0125 .10301 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0.5)] -0.0125 .30902 1 0 Mshowa
0 .41202 m
.00625 .41202 L
s
[(1)] -0.0125 .41202 1 0 Mshowa
0 .51503 m
.00625 .51503 L
s
[(1.5)] -0.0125 .51503 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(2)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0206 m
.00375 .0206 L
s
0 .0412 m
.00375 .0412 L
s
0 .0618 m
.00375 .0618 L
s
0 .0824 m
.00375 .0824 L
s
0 .12361 m
.00375 .12361 L
s
0 .14421 m
.00375 .14421 L
s
0 .16481 m
.00375 .16481 L
s
0 .18541 m
.00375 .18541 L
s
0 .22661 m
.00375 .22661 L
s
0 .24721 m
.00375 .24721 L
s
0 .26781 m
.00375 .26781 L
s
0 .28842 m
.00375 .28842 L
s
0 .32962 m
.00375 .32962 L
s
0 .35022 m
.00375 .35022 L
s
0 .37082 m
.00375 .37082 L
s
0 .39142 m
.00375 .39142 L
s
0 .43262 m
.00375 .43262 L
s
0 .45322 m
.00375 .45322 L
s
0 .47383 m
.00375 .47383 L
s
0 .49443 m
.00375 .49443 L
s
0 .53563 m
.00375 .53563 L
s
0 .55623 m
.00375 .55623 L
s
0 .57683 m
.00375 .57683 L
s
0 .59743 m
.00375 .59743 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .20601 m
.00041 .20601 L
.00079 .20601 L
.00122 .20601 L
.00163 .20602 L
.00235 .20602 L
.00314 .20603 L
.00401 .20604 L
.00493 .20606 L
.00658 .20609 L
.00829 .20614 L
.00989 .20619 L
.01352 .20635 L
.01723 .20656 L
.02063 .2068 L
.02827 .20749 L
.03491 .20827 L
.04217 .20931 L
.05639 .21191 L
.07009 .21512 L
.08464 .21929 L
.09867 .22406 L
.11216 .22934 L
.12651 .23569 L
.14033 .24252 L
.15362 .24977 L
.16777 .2582 L
.18139 .26701 L
.19586 .27714 L
.20981 .28763 L
.22322 .2984 L
.2375 .31059 L
.25124 .32305 L
.26445 .33568 L
.27853 .34985 L
.29207 .36417 L
.30646 .38015 L
.32033 .39627 L
.33333 .41202 L
s
.33667 .23074 m
.35005 .22686 L
.36465 .22299 L
.37837 .21973 L
.39155 .21691 L
.40559 .21427 L
.4191 .21208 L
.43346 .21012 L
.4473 .20859 L
.46061 .20745 L
.46748 .20699 L
.47477 .2066 L
.47803 .20646 L
.48154 .20633 L
.48482 .20622 L
.48788 .20615 L
.49138 .20608 L
.49323 .20605 L
.49417 .20604 L
.4952 .20603 L
.49618 .20602 L
.49708 .20602 L
.49794 .20602 L
.49837 .20601 L
.49862 .20601 L
.49885 .20601 L
.49928 .20601 L
.49968 .20601 L
.5001 .20601 L
.50034 .20601 L
.50056 .20601 L
.50093 .20601 L
.50134 .20601 L
.50176 .20601 L
.50216 .20602 L
.503 .20602 L
.50379 .20602 L
.50557 .20604 L
.5073 .20606 L
.50915 .20609 L
.51251 .20616 L
.51557 .20624 L
.52221 .20647 L
.52942 .20681 L
.5436 .20777 L
.55725 .20905 L
.57038 .2106 L
.58436 .21261 L
.59781 .21488 L
.61211 .21766 L
Mistroke
.62589 .2207 L
.63914 .22396 L
.65324 .22778 L
.66667 .23176 L
Mfstroke
.67 .60977 m
.68339 .57618 L
.69799 .53879 L
.7117 .50295 L
.72489 .46783 L
.73892 .42973 L
.75243 .39237 L
.76679 .35192 L
.78063 .31222 L
.79394 .27336 L
.8081 .2313 L
.82173 .1901 L
.83484 .14983 L
.8488 .10626 L
.86224 .06364 L
.87652 .01759 L
s
.87652 .01759 m
.88189 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{214.875, 132.812},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0000Q2000`400?l00000o`00003oe_ooool0
0=Kooooo003Fooooo`00e_ooool00=Kooooo003Fooooo`004oooool3o`000<3ooooo000Dooooo`03
o`000?oooooooooo0;oooooo000<ooooo`Go00000oooool00ol0003oooooooooo`2oooooo`005?oo
ool00ol0003oooooooooo`03ooooo`;o0000XOooool00ol0003oooooooooo`0Fooooo`005?ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:3ooooo00?o0000ooooooooool05_ooool0
01?ooooo0_l00005ooooo`03o`000?oooooooooo09oooooo00?o0000ooooooooool05oooool001Co
oooo00?o0000ooooooooool00oooool2o`000:3ooooo00?o0000ooooooooool05oooool001[ooooo
00?o0000ooooooooool0Woooool00ol0003oooooooooo`0Gooooo`006_ooool00ol0003ooooooooo
o`2Nooooo`03o`000?oooooooooo01Sooooo000Jooooo`03o`000?oooooooooo09kooooo00?o0000
ooooooooool06?ooool001[ooooo0_l0002Oooooo`03o`000?oooooooooo01Sooooo000Jooooo`03
o`000?oooooooooo09gooooo00?o0000ooooooooool06Oooool001[ooooo00?o0000ooooooooool0
WOooool00ol0003oooooooooo`0Iooooo`006_ooool00ol0003oooooooooo`2Mooooo`03o`000?oo
oooooooo01Wooooo000Jooooo`;o0000WOooool00ol0003oooooooooo`0Jooooo`006_ooool00ol0
003oooooooooo`2Looooo`03o`000?oooooooooo01[ooooo000Jooooo`03o`000?oooooooooo09_o
oooo00?o0000ooooooooool06oooool001[ooooo00?o0000ooooooooool0Voooool00ol0003ooooo
ooooo`0Kooooo`006_ooool2o`0009cooooo00?o0000ooooooooool06oooool000Sooooo0_l00004
ooooo`03o`000?oooooooooo00;ooooo0ol00004ooooo`03o`000?oooooooooo09[ooooo00?o0000
ooooooooool07?ooool000Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooo
oooo000000?ooooo00?o0000ooooooooool0V_ooool00ol0003oooooooooo`0Looooo`001Ol00002
ooooo`04o`000?ooooooooooo`0000_ooooo00Go0000ooooooooooooooooo`00002Looooo`03o`00
0?oooooooooo01cooooo0007ooooo`04o`000?ooooooooooo`0000_ooooo00Co0000oooooooooooo
oooo0_l0002Jooooo`03o`000?oooooooooo01gooooo0007ooooo`04o`000?ooooooooooo`0000Oo
oooo1?l00004ooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool07Oooool000Oooooo
00Co0000oooooooooooo00001oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo09Wo
oooo00?o0000ooooooooool07Oooool000Sooooo0_l00008ooooo`Go00000oooool2o`0009Wooooo
00?o0000ooooooooool07_ooool001[ooooo00?o0000ooooooooool0V?ooool00ol0003ooooooooo
o`0Nooooo`006_ooool00ol0003oooooooooo`2Hooooo`03o`000?oooooooooo01kooooo000Joooo
o`03o`000?oooooooooo09Sooooo00?o0000ooooooooool07_ooool001[ooooo0_l0002Hooooo`03
o`000?oooooooooo01oooooo000Jooooo`03o`000?oooooooooo01Gooooo0_l00004ooooo`03o`00
0?oooooooooo00;ooooo0ol0000Eooooo`?o00005_ooool3o`0000Cooooo00?o0000ooooooooool0
0_ooool3o`0001Gooooo1Ol0000Dooooo`Go00000oooool2o`0000?ooooo0ol0000Eooooo`?o0000
0oooool001[ooooo00?o0000ooooooooool05?ooool01?l0003oooooooooool00007ooooo`05o`00
0?ooooooooooooooool000005Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00Oo
oooo00Go0000ooooooooooooooooo`00000Eooooo`04o`000?ooooooooooo`0001Gooooo00Co0000
oooooooooooo00001?ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo017ooooo
00Go0000ooooooooooooooooo`000002ooooo`006_ooool00ol0003oooooooooo`0Dooooo`04o`00
0?ooooooooooo`0000_ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Fooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Fooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Eooooo`7o
00000Oooool1ooooo`006_ooool2o`0001Gooooo00Co0000oooooooooooo00002oooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0Eooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo01?ooooo0_l00003ooooo`006_ooool00ol0003ooooo
ooooo`0Dooooo`04o`000?ooooooooooo`0000Oooooo1?l0000Fooooo`03o`000?oooooooooo01Ko
oooo00?o0000ooooooooool01oooool4o`0001Gooooo00Go0000ooooooooooooooooo`00000Doooo
o`05o`000?ooooooooooooooool000000oooool01?l0003oooooooooooooool4o`0001Sooooo0Ol0
0001ooooo`7ooooo000Jooooo`03o`000?oooooooooo01Cooooo00Co0000oooooooooooo00001ooo
ool00ol0003oooooooooo`0Fooooo`;o00005oooool2o`0000Wooooo00?o0000ooooooooool05_oo
ool01Ol0003ooooooooooooooooo000001Cooooo00Go0000ooooooooooooooooo`000002ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool05Oooool01Ol0003ooooooooooooooooo0000
00;ooooo000Jooooo`03o`000?oooooooooo01Gooooo0_l00008ooooo`Go00005Oooool00ol0003o
ooooooooo`0Fooooo`03o`000?oooooooooo00Oooooo1Ol0000Eooooo`?o00005_ooool3o`0000?o
oooo00?o0000ooooooooool00_ooool5o`0001Cooooo0ol00003ooooo`006_ooool2o`0009Kooooo
00?o0000ooooooooool08Oooool001[ooooo00?o0000ooooooooool0U?ooool00ol0003ooooooooo
o`0Rooooo`006_ooool00ol0003oooooooooo`2Dooooo`03o`000?oooooooooo02;ooooo000Joooo
o`03o`000?oooooooooo09Cooooo00?o0000ooooooooool08_ooool001[ooooo^Ol00003ooooo`00
6_ooool00ol0003oooooooooo`07ooooo`Go00004?ooool00ol0003oooooooooo`0Kooooo`03o`00
0?oooooooooo00[ooooo1Ol0000=ooooo`03o`000?oooooooooo00gooooo1Ol0000:ooooo`03o`00
0?oooooooooo01Sooooo00Go0000ooooooooooooooooo`00000Mooooo`03o`000?oooooooooo007o
oooo000Jooooo`03o`000?oooooooooo00cooooo0ol0000cooooo`Go00009oooool5o`00023ooooo
00?o0000ooooooooool08oooool001[ooooo0_l0000@ooooo`?o0000:_ooool6o`00037ooooo0_l0
000Mooooo`03o`000?oooooooooo02Cooooo000Jooooo`03o`000?oooooooooo01;ooooo0_l0000W
ooooo`03o`000?oooooooooo03Oooooo1?l0000Iooooo`03o`000?oooooooooo02Cooooo000Joooo
o`03o`000?oooooooooo01Cooooo0ol0001kooooo`03o`000?oooooooooo02Cooooo000Jooooo`03
o`000?oooooooooo01Oooooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`0Uooooo`00
6_ooool2o`0001Wooooo00?o0000ooooooooool0M_ooool00ol0003oooooooooo`0Uooooo`006_oo
ool00ol0003oooooooooo`0Iooooo`?o0000MOooool00ol0003oooooooooo`0Uooooo`006_ooool0
0ol0003oooooooooo`0Looooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool09_ooool0
01[ooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo
02Kooooo000Jooooo`;o00007oooool2o`00073ooooo00?o0000ooooooooool09_ooool001[ooooo
00?o0000ooooooooool08?ooool00ol0003oooooooooo`1/ooooo`03o`000?oooooooooo02Oooooo
000Jooooo`03o`000?oooooooooo027ooooo0_l0001/ooooo`03o`000?oooooooooo02Oooooo000J
ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool0JOooool00ol0003oooooooooo`0W
ooooo`006_ooool2o`0002Gooooo00?o0000ooooooooool0Ioooool00ol0003oooooooooo`0Xoooo
o`002?ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Cooooo00?o0000oooooooo
ool09Oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo02Sooooo0007ooooo`04o`00
0?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo
02Kooooo0_l0001Vooooo`03o`000?oooooooooo02Sooooo0007ooooo`04o`000?ooooooooooo`00
00_ooooo00Go0000ooooooooooooooooo`00000Zooooo`03o`000?oooooooooo06;ooooo00?o0000
ooooooooool0:Oooool000Oooooo00Co0000oooooooooooo00002oooool01?l0003ooooooooooooo
ool2o`0002[ooooo00?o0000ooooooooool0HOooool00ol0003oooooooooo`0Yooooo`001oooool0
1?l0003oooooooooool00007ooooo`Co00001?ooool00ol0003oooooooooo`0Zooooo`03o`000?oo
oooooooo063ooooo00?o0000ooooooooool0:Oooool000Oooooo00Co0000oooooooooooo00001ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool0G_oo
ool00ol0003oooooooooo`0Zooooo`002?ooool2o`0000Sooooo1Ol00003ooooo`;o0000;Oooool0
0ol0003oooooooooo`1Mooooo`03o`000?oooooooooo02[ooooo000Jooooo`03o`000?oooooooooo
02gooooo00?o0000ooooooooool0G?ooool00ol0003oooooooooo`0Zooooo`006_ooool00ol0003o
ooooooooo`0^ooooo`03o`000?oooooooooo05[ooooo00?o0000ooooooooool0:oooool001[ooooo
00?o0000ooooooooool0;oooool00ol0003oooooooooo`1Iooooo`03o`000?oooooooooo02_ooooo
000Jooooo`;o0000<Oooool00ol0003oooooooooo`1Hooooo`03o`000?oooooooooo02_ooooo000J
ooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool0E_ooool00ol0003oooooooooo`0/
ooooo`006_ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo05Gooooo00?o0000oooo
ooooool0;?ooool001[ooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`1Dooooo`03
o`000?oooooooooo02cooooo000Jooooo`;o0000=?ooool00ol0003oooooooooo`1Cooooo`03o`00
0?oooooooooo02gooooo000Jooooo`03o`000?oooooooooo03Cooooo00?o0000ooooooooool0D_oo
ool00ol0003oooooooooo`0]ooooo`006_ooool00ol0003oooooooooo`0eooooo`03o`000?oooooo
oooo057ooooo00?o0000ooooooooool0;Oooool001[ooooo00?o0000ooooooooool0=_ooool00ol0
003oooooooooo`1?ooooo`03o`000?oooooooooo02kooooo000Jooooo`;o0000>?ooool00ol0003o
ooooooooo`1>ooooo`03o`000?oooooooooo02kooooo000Cooooo`?o00001?ooool00ol0003ooooo
ooooo`0hooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0;_ooool001Cooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0hooooo`03o`000?oooooooooo04cooooo00?o
0000ooooooooool0;oooool001Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0i
ooooo`03o`000?oooooooooo04_ooooo00?o0000ooooooooool0;oooool001Cooooo00?o0000oooo
ooooool00oooool2o`0003_ooooo00?o0000ooooooooool0BOooool00ol0003oooooooooo`0`oooo
o`005?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo08Kooooo00?o0000oooooooo
ool0<?ooool001?ooooo0_l00005ooooo`03o`000?oooooooooo08Kooooo00?o0000ooooooooool0
<?ooool001Cooooo00?o0000ooooooooool00oooool2o`0008Kooooo00?o0000ooooooooool0<Ooo
ool001[ooooo00?o0000ooooooooool0QOooool00ol0003oooooooooo`0aooooo`006_ooool00ol0
003oooooooooo`25ooooo`03o`000?oooooooooo037ooooo000Jooooo`03o`000?oooooooooo08Co
oooo00?o0000ooooooooool0<_ooool001[ooooo0_l00025ooooo`03o`000?oooooooooo03;ooooo
000Jooooo`03o`000?oooooooooo08Cooooo00?o0000ooooooooool0<_ooool001[ooooo00?o0000
ooooooooool0Poooool00ol0003oooooooooo`0cooooo`006_ooool00ol0003oooooooooo`23oooo
o`03o`000?oooooooooo03?ooooo000Jooooo`;o0000Q?ooool00ol0003oooooooooo`0cooooo`00
6_ooool00ol0003oooooooooo`22ooooo`03o`000?oooooooooo03Cooooo000Jooooo`03o`000?oo
oooooooo08;ooooo00?o0000ooooooooool0=?ooool001[ooooo00?o0000ooooooooool0POooool0
0ol0003oooooooooo`0eooooo`006_ooool2o`0008;ooooo00?o0000ooooooooool0=Oooool000Oo
oooo0ol00004ooooo`03o`000?oooooooooo00;ooooo0ol00004ooooo`03o`000?oooooooooo083o
oooo00?o0000ooooooooool0=_ooool000Sooooo00?o0000ooooooooool01oooool01Ol0003ooooo
oooooooooooo000000?ooooo00?o0000ooooooooool0P?ooool00ol0003oooooooooo`0fooooo`00
2?ooool00ol0003oooooooooo`0;ooooo`05o`000?ooooooooooooooool00000P_ooool00ol0003o
ooooooooo`0fooooo`002?ooool00ol0003oooooooooo`0;ooooo`04o`000?ooooooooooooooo`;o
0000P?ooool00ol0003oooooooooo`0gooooo`002?ooool00ol0003oooooooooo`07ooooo`Co0000
1?ooool00ol0003oooooooooo`1oooooo`03o`000?oooooooooo03Oooooo0007ooooo`;o00002Ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool0=ooo
ool000Sooooo00?o0000ooooooooool01oooool5o`0000?ooooo0_l0001oooooo`03o`000?oooooo
oooo03Sooooo000Jooooo`03o`000?oooooooooo07kooooo00?o0000ooooooooool0>?ooool001[o
oooo00?o0000ooooooooool0O_ooool00ol0003oooooooooo`0hooooo`006_ooool00ol0003ooooo
ooooo`1mooooo`03o`000?oooooooooo03Wooooo000Jooooo`;o0000O_ooool00ol0003ooooooooo
o`0iooooo`006_ooool00ol0003oooooooooo`1looooo`03o`000?oooooooooo03[ooooo000Joooo
o`03o`000?oooooooooo07cooooo00?o0000ooooooooool0>_ooool001[ooooo00?o0000oooooooo
ool0O?ooool00ol0003oooooooooo`0jooooo`006_ooool2o`0007cooooo00?o0000ooooooooool0
>oooool001[ooooo00?o0000ooooooooool0Noooool00ol0003oooooooooo`0kooooo`006_ooool0
0ol0003oooooooooo`1jooooo`03o`000?oooooooooo03cooooo000Jooooo`03o`000?oooooooooo
07[ooooo00?o0000ooooooooool0??ooool001[ooooo0_l0001jooooo`03o`000?oooooooooo03go
oooo000Booooo`Go00000oooool00ol0003oooooooooo`1iooooo`03o`000?oooooooooo03gooooo
000Cooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool0N?ooool00ol0003ooooo
ooooo`0nooooo`005?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0;Wooooo000E
ooooo`03o`000?oooooooooo00;ooooo0_l0002jooooo`004_ooool01Ol0003ooooooooooooooooo
00000;oooooo000Booooo`05o`000?ooooooooooooooool00000_oooool001?ooooo0ol00030oooo
o`00e_ooool00=Kooooo003Fooooo`00e_ooool00=Kooooo0000\
\>"],
  ImageRangeCache->{{{0, 213.875}, {131.812, 0}} -> {-0.42762, -1.23335, \
0.0162544, 0.0263001}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[GraphicsArray[{p0, p4}]];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.235357 0.559097 [
[.18254 .22286 -9 -9 ]
[.18254 .22286 9 0 ]
[.34127 .22286 -3 -9 ]
[.34127 .22286 3 0 ]
[.5 .22286 -9 -9 ]
[.5 .22286 9 0 ]
[.65873 .22286 -3 -9 ]
[.65873 .22286 3 0 ]
[.81746 .22286 -9 -9 ]
[.81746 .22286 9 0 ]
[.97619 .22286 -3 -9 ]
[.97619 .22286 3 0 ]
[.01131 .01172 -24 -4.5 ]
[.01131 .01172 0 4.5 ]
[.01131 .12354 -24 -4.5 ]
[.01131 .12354 0 4.5 ]
[.01131 .34718 -18 -4.5 ]
[.01131 .34718 0 4.5 ]
[.01131 .459 -18 -4.5 ]
[.01131 .459 0 4.5 ]
[.01131 .57082 -18 -4.5 ]
[.01131 .57082 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .23536 m
.18254 .24161 L
s
[(0.5)] .18254 .22286 0 1 Mshowa
.34127 .23536 m
.34127 .24161 L
s
[(1)] .34127 .22286 0 1 Mshowa
.5 .23536 m
.5 .24161 L
s
[(1.5)] .5 .22286 0 1 Mshowa
.65873 .23536 m
.65873 .24161 L
s
[(2)] .65873 .22286 0 1 Mshowa
.81746 .23536 m
.81746 .24161 L
s
[(2.5)] .81746 .22286 0 1 Mshowa
.97619 .23536 m
.97619 .24161 L
s
[(3)] .97619 .22286 0 1 Mshowa
.125 Mabswid
.05556 .23536 m
.05556 .23911 L
s
.0873 .23536 m
.0873 .23911 L
s
.11905 .23536 m
.11905 .23911 L
s
.15079 .23536 m
.15079 .23911 L
s
.21429 .23536 m
.21429 .23911 L
s
.24603 .23536 m
.24603 .23911 L
s
.27778 .23536 m
.27778 .23911 L
s
.30952 .23536 m
.30952 .23911 L
s
.37302 .23536 m
.37302 .23911 L
s
.40476 .23536 m
.40476 .23911 L
s
.43651 .23536 m
.43651 .23911 L
s
.46825 .23536 m
.46825 .23911 L
s
.53175 .23536 m
.53175 .23911 L
s
.56349 .23536 m
.56349 .23911 L
s
.59524 .23536 m
.59524 .23911 L
s
.62698 .23536 m
.62698 .23911 L
s
.69048 .23536 m
.69048 .23911 L
s
.72222 .23536 m
.72222 .23911 L
s
.75397 .23536 m
.75397 .23911 L
s
.78571 .23536 m
.78571 .23911 L
s
.84921 .23536 m
.84921 .23911 L
s
.88095 .23536 m
.88095 .23911 L
s
.9127 .23536 m
.9127 .23911 L
s
.94444 .23536 m
.94444 .23911 L
s
.25 Mabswid
0 .23536 m
1 .23536 L
s
.02381 .01172 m
.03006 .01172 L
s
[(-0.4)] .01131 .01172 1 0 Mshowa
.02381 .12354 m
.03006 .12354 L
s
[(-0.2)] .01131 .12354 1 0 Mshowa
.02381 .34718 m
.03006 .34718 L
s
[(0.2)] .01131 .34718 1 0 Mshowa
.02381 .459 m
.03006 .459 L
s
[(0.4)] .01131 .459 1 0 Mshowa
.02381 .57082 m
.03006 .57082 L
s
[(0.6)] .01131 .57082 1 0 Mshowa
.125 Mabswid
.02381 .03967 m
.02756 .03967 L
s
.02381 .06763 m
.02756 .06763 L
s
.02381 .09558 m
.02756 .09558 L
s
.02381 .15149 m
.02756 .15149 L
s
.02381 .17945 m
.02756 .17945 L
s
.02381 .2074 m
.02756 .2074 L
s
.02381 .26331 m
.02756 .26331 L
s
.02381 .29127 m
.02756 .29127 L
s
.02381 .31922 m
.02756 .31922 L
s
.02381 .37513 m
.02756 .37513 L
s
.02381 .40309 m
.02756 .40309 L
s
.02381 .43104 m
.02756 .43104 L
s
.02381 .48695 m
.02756 .48695 L
s
.02381 .51491 m
.02756 .51491 L
s
.02381 .54286 m
.02756 .54286 L
s
.02381 .59877 m
.02756 .59877 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02519 .23537 m
.02673 .2354 L
.02842 .23548 L
.02937 .23553 L
.03024 .23559 L
.03198 .23573 L
.03387 .23592 L
.03733 .23637 L
.04052 .23691 L
.04392 .2376 L
.05005 .23918 L
.05782 .24177 L
.06513 .24483 L
.07881 .25214 L
.10438 .27137 L
.13205 .30035 L
.15863 .3362 L
.18672 .38259 L
.23735 .48833 L
.26554 .55953 L
s
.26554 .55953 m
.28625 .61803 L
s
.34062 .61803 m
.34165 .30491 L
.34313 .30362 L
.3705 .28188 L
.39596 .26538 L
.42053 .25288 L
.43418 .24737 L
.44677 .24322 L
.46043 .2397 L
.46762 .23827 L
.47523 .23706 L
.47842 .23665 L
.48184 .23627 L
.4848 .236 L
.48803 .23576 L
.48998 .23564 L
.4918 .23554 L
.49353 .23547 L
.49442 .23544 L
.49538 .23542 L
.49633 .23539 L
.4972 .23538 L
.49891 .23536 L
.50046 .23536 L
.5021 .23537 L
.50373 .2354 L
.50466 .23542 L
.50551 .23544 L
.50704 .23549 L
.50873 .23557 L
.51166 .23573 L
.51477 .23596 L
.52177 .23667 L
.52834 .23758 L
.54012 .23982 L
.5528 .24309 L
.56559 .24729 L
.57957 .25292 L
.60772 .26754 L
.63392 .28511 L
.64146 .29087 L
.64858 .29659 L
.65496 .30196 L
.65671 .30348 L
.65767 .30431 L
.65856 .30509 L
s
.65856 .30509 m
.65904 .61803 L
s
.75535 .61803 m
.76881 .51083 L
.8219 .0564 L
s
.8219 .0564 m
.82807 0 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.333333 0.206011 0.206011 [
[.16667 .19351 -9 -9 ]
[.16667 .19351 9 0 ]
[.33333 .19351 -3 -9 ]
[.33333 .19351 3 0 ]
[.5 .19351 -9 -9 ]
[.5 .19351 9 0 ]
[.66667 .19351 -3 -9 ]
[.66667 .19351 3 0 ]
[.83333 .19351 -9 -9 ]
[.83333 .19351 9 0 ]
[1 .19351 -3 -9 ]
[1 .19351 3 0 ]
[-0.0125 0 -12 -4.5 ]
[-0.0125 0 0 4.5 ]
[-0.0125 .10301 -24 -4.5 ]
[-0.0125 .10301 0 4.5 ]
[-0.0125 .30902 -18 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .41202 -6 -4.5 ]
[-0.0125 .41202 0 4.5 ]
[-0.0125 .51503 -18 -4.5 ]
[-0.0125 .51503 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16667 .20601 m
.16667 .21226 L
s
[(0.5)] .16667 .19351 0 1 Mshowa
.33333 .20601 m
.33333 .21226 L
s
[(1)] .33333 .19351 0 1 Mshowa
.5 .20601 m
.5 .21226 L
s
[(1.5)] .5 .19351 0 1 Mshowa
.66667 .20601 m
.66667 .21226 L
s
[(2)] .66667 .19351 0 1 Mshowa
.83333 .20601 m
.83333 .21226 L
s
[(2.5)] .83333 .19351 0 1 Mshowa
1 .20601 m
1 .21226 L
s
[(3)] 1 .19351 0 1 Mshowa
.125 Mabswid
.03333 .20601 m
.03333 .20976 L
s
.06667 .20601 m
.06667 .20976 L
s
.1 .20601 m
.1 .20976 L
s
.13333 .20601 m
.13333 .20976 L
s
.2 .20601 m
.2 .20976 L
s
.23333 .20601 m
.23333 .20976 L
s
.26667 .20601 m
.26667 .20976 L
s
.3 .20601 m
.3 .20976 L
s
.36667 .20601 m
.36667 .20976 L
s
.4 .20601 m
.4 .20976 L
s
.43333 .20601 m
.43333 .20976 L
s
.46667 .20601 m
.46667 .20976 L
s
.53333 .20601 m
.53333 .20976 L
s
.56667 .20601 m
.56667 .20976 L
s
.6 .20601 m
.6 .20976 L
s
.63333 .20601 m
.63333 .20976 L
s
.7 .20601 m
.7 .20976 L
s
.73333 .20601 m
.73333 .20976 L
s
.76667 .20601 m
.76667 .20976 L
s
.8 .20601 m
.8 .20976 L
s
.86667 .20601 m
.86667 .20976 L
s
.9 .20601 m
.9 .20976 L
s
.93333 .20601 m
.93333 .20976 L
s
.96667 .20601 m
.96667 .20976 L
s
.25 Mabswid
0 .20601 m
1 .20601 L
s
0 0 m
.00625 0 L
s
[(-1)] -0.0125 0 1 0 Mshowa
0 .10301 m
.00625 .10301 L
s
[(-0.5)] -0.0125 .10301 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0.5)] -0.0125 .30902 1 0 Mshowa
0 .41202 m
.00625 .41202 L
s
[(1)] -0.0125 .41202 1 0 Mshowa
0 .51503 m
.00625 .51503 L
s
[(1.5)] -0.0125 .51503 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(2)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0206 m
.00375 .0206 L
s
0 .0412 m
.00375 .0412 L
s
0 .0618 m
.00375 .0618 L
s
0 .0824 m
.00375 .0824 L
s
0 .12361 m
.00375 .12361 L
s
0 .14421 m
.00375 .14421 L
s
0 .16481 m
.00375 .16481 L
s
0 .18541 m
.00375 .18541 L
s
0 .22661 m
.00375 .22661 L
s
0 .24721 m
.00375 .24721 L
s
0 .26781 m
.00375 .26781 L
s
0 .28842 m
.00375 .28842 L
s
0 .32962 m
.00375 .32962 L
s
0 .35022 m
.00375 .35022 L
s
0 .37082 m
.00375 .37082 L
s
0 .39142 m
.00375 .39142 L
s
0 .43262 m
.00375 .43262 L
s
0 .45322 m
.00375 .45322 L
s
0 .47383 m
.00375 .47383 L
s
0 .49443 m
.00375 .49443 L
s
0 .53563 m
.00375 .53563 L
s
0 .55623 m
.00375 .55623 L
s
0 .57683 m
.00375 .57683 L
s
0 .59743 m
.00375 .59743 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .20601 m
.00041 .20601 L
.00079 .20601 L
.00122 .20601 L
.00163 .20602 L
.00235 .20602 L
.00314 .20603 L
.00401 .20604 L
.00493 .20606 L
.00658 .20609 L
.00829 .20614 L
.00989 .20619 L
.01352 .20635 L
.01723 .20656 L
.02063 .2068 L
.02827 .20749 L
.03491 .20827 L
.04217 .20931 L
.05639 .21191 L
.07009 .21512 L
.08464 .21929 L
.09867 .22406 L
.11216 .22934 L
.12651 .23569 L
.14033 .24252 L
.15362 .24977 L
.16777 .2582 L
.18139 .26701 L
.19586 .27714 L
.20981 .28763 L
.22322 .2984 L
.2375 .31059 L
.25124 .32305 L
.26445 .33568 L
.27853 .34985 L
.29207 .36417 L
.30646 .38015 L
.32033 .39627 L
.33333 .41202 L
s
.33667 .23074 m
.35005 .22686 L
.36465 .22299 L
.37837 .21973 L
.39155 .21691 L
.40559 .21427 L
.4191 .21208 L
.43346 .21012 L
.4473 .20859 L
.46061 .20745 L
.46748 .20699 L
.47477 .2066 L
.47803 .20646 L
.48154 .20633 L
.48482 .20622 L
.48788 .20615 L
.49138 .20608 L
.49323 .20605 L
.49417 .20604 L
.4952 .20603 L
.49618 .20602 L
.49708 .20602 L
.49794 .20602 L
.49837 .20601 L
.49862 .20601 L
.49885 .20601 L
.49928 .20601 L
.49968 .20601 L
.5001 .20601 L
.50034 .20601 L
.50056 .20601 L
.50093 .20601 L
.50134 .20601 L
.50176 .20601 L
.50216 .20602 L
.503 .20602 L
.50379 .20602 L
.50557 .20604 L
.5073 .20606 L
.50915 .20609 L
.51251 .20616 L
.51557 .20624 L
.52221 .20647 L
.52942 .20681 L
.5436 .20777 L
.55725 .20905 L
.57038 .2106 L
.58436 .21261 L
.59781 .21488 L
.61211 .21766 L
Mistroke
.62589 .2207 L
.63914 .22396 L
.65324 .22778 L
.66667 .23176 L
Mfstroke
.67 .60977 m
.68339 .57618 L
.69799 .53879 L
.7117 .50295 L
.72489 .46783 L
.73892 .42973 L
.75243 .39237 L
.76679 .35192 L
.78063 .31222 L
.79394 .27336 L
.8081 .2313 L
.82173 .1901 L
.83484 .14983 L
.8488 .10626 L
.86224 .06364 L
.87652 .01759 L
s
.87652 .01759 m
.88189 0 L
s
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{416, 122.375},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006P0000NR000`400?l00000o`00003ooooooonQ
ooooo`00oooooonQooooo`00oooooonQooooo`00oooooonQooooo`00oooooonQooooo`00oooooonQ
ooooo`00oooooonQooooo`00oooooonQooooo`00oooooonQooooo`00joooool3o`000;;ooooo003/
ooooo`03o`000?oooooooooo0;7ooooo000Cooooo`;o00001?ooool00ol0003oooooooooo`03oooo
o`?o00000oooool00ol0003oooooooooo`21ooooo`03o`000?oooooooooo03Sooooo1Ol00003oooo
o`03o`000?oooooooooo0;7ooooo000Booooo`04o`000?ooooooooooo`0000[ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`21ooooo`03o`000?oooooooooo043ooooo00?o0000oooo
ooooool00oooool2o`0008[ooooo00?o0000ooooooooool07oooool000_ooooo1Ol00002ooooo`04
o`000?ooooooooooo`0000Oooooo1Ol00003ooooo`;o0000P_ooool00ol0003oooooooooo`10oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0ROooool00ol0003oooooooooo`0Ooooo
o`004_ooool01?l0003oooooooooool00007ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000
ooooooooool0POooool00ol0003oooooooooo`0oooooo`;o00001Oooool00ol0003oooooooooo`28
ooooo`03o`000?oooooooooo023ooooo000Booooo`04o`000?ooooooooooo`0000Sooooo00?o0000
ooooool000001?ooool00ol0003oooooooooo`21ooooo`03o`000?oooooooooo043ooooo00?o0000
ooooooooool00oooool2o`0008Wooooo00?o0000ooooooooool08?ooool001;ooooo00Co0000oooo
oooooooo00002Oooool2o`0000Cooooo00?o0000ooooooooool0P?ooool00ol0003oooooooooo`17
ooooo`03o`000?oooooooooo08Sooooo00?o0000ooooooooool08?ooool001?ooooo0_l0000;oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0P?ooool00ol0003oooooooooo`17oooo
o`03o`000?oooooooooo08Sooooo00?o0000ooooooooool08?ooool002Gooooo00?o0000oooooooo
ool0P?ooool00ol0003oooooooooo`17ooooo`03o`000?oooooooooo08Oooooo00?o0000oooooooo
ool08Oooool002Gooooo00?o0000ooooooooool0P?ooool00ol0003oooooooooo`17ooooo`;o0000
R?ooool00ol0003oooooooooo`0Qooooo`009Oooool00ol0003oooooooooo`20ooooo`03o`000?oo
oooooooo04Oooooo00?o0000ooooooooool0Qoooool00ol0003oooooooooo`0Qooooo`009Oooool0
0ol0003oooooooooo`20ooooo`03o`000?oooooooooo04Oooooo00?o0000ooooooooool0Q_ooool0
0ol0003oooooooooo`0Rooooo`009Oooool00ol0003oooooooooo`20ooooo`03o`000?oooooooooo
04Oooooo0_l00027ooooo`03o`000?oooooooooo02;ooooo000Uooooo`03o`000?oooooooooo083o
oooo00?o0000ooooooooool0Aoooool00ol0003oooooooooo`26ooooo`03o`000?oooooooooo02;o
oooo000Uooooo`03o`000?oooooooooo083ooooo00?o0000ooooooooool0Aoooool00ol0003ooooo
ooooo`25ooooo`03o`000?oooooooooo02?ooooo000Uooooo`03o`000?oooooooooo07oooooo00?o
0000ooooooooool0B?ooool2o`0008Kooooo00?o0000ooooooooool08oooool002Gooooo00?o0000
ooooooooool0Ooooool00ol0003oooooooooo`0fooooo`;o00001?ooool00ol0003oooooooooo`02
ooooo`?o00001?ooool00ol0003oooooooooo`24ooooo`03o`000?oooooooooo02Cooooo000Uoooo
o`03o`000?oooooooooo07oooooo00?o0000ooooooooool0=Oooool01?l0003oooooooooool00007
ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`24ooooo`03o`000?oo
oooooooo02Cooooo000Uooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool0;_ooool5
o`0000;ooooo00Co0000oooooooooooo00002oooool01?l0003oooooooooooooool2o`0008Gooooo
00?o0000ooooooooool09?ooool001?ooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go0000
0oooool00ol0003oooooooooo`1oooooo`03o`000?oooooooooo03Gooooo00Co0000oooooooooooo
00002oooool01Ol0003ooooooooooooooooo000008Gooooo00?o0000ooooooooool09Oooool001;o
oooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool00003ooooo`03o`000?oooooo
oooo07oooooo00?o0000ooooooooool0=Oooool01?l0003oooooooooool00007ooooo`Co00001?oo
ool00ol0003oooooooooo`23ooooo`03o`000?oooooooooo02Gooooo000;ooooo`Go00000_ooool0
1?l0003oooooooooool00009ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Oooo
ool00ol0003oooooooooo`0eooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`23ooooo`03o`000?oooooooooo02Gooooo000Booooo`04o`000?oo
ooooooooo`0000[ooooo00?o0000ooooooooool00_ooool2o`00083ooooo00?o0000ooooooooool0
=_ooool2o`0000Sooooo1Ol00003ooooo`;o0000Poooool00ol0003oooooooooo`0Vooooo`004_oo
ool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000000oooool00ol0003o
ooooooooo`1nooooo`03o`000?oooooooooo04Wooooo00?o0000ooooooooool0P_ooool00ol0003o
ooooooooo`0Vooooo`004_ooool01?l0003oooooooooool00007ooooo`05o`000?oooooooooooooo
ool000000oooool00ol0003oooooooooo`1nooooo`03o`000?oooooooooo04Wooooo00?o0000oooo
ooooool0P_ooool00ol0003oooooooooo`0Vooooo`004oooool2o`0000Wooooo0ol00004ooooo`03
o`000?oooooooooo07kooooo00?o0000ooooooooool0BOooool2o`0001;ooooo0_l00004ooooo`03
o`000?oooooooooo00;ooooo0ol0000Aooooo`?o00004Oooool3o`0000Cooooo00?o0000oooooooo
ool00_ooool3o`00017ooooo1Ol0000?ooooo`Go00000oooool2o`0000?ooooo0ol0000Aooooo`?o
00003oooool002Gooooo00?o0000ooooooooool0O_ooool00ol0003oooooooooo`19ooooo`03o`00
0?oooooooooo013ooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo0000
017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`07ooooo`05o`000?oooooooooo
ooooool000004Oooool01?l0003oooooooooool0000@ooooo`04o`000?ooooooooooo`0000Cooooo
00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0=ooooo`05o`000?oooooooooooooo
ool000003_ooool002Gooooo00?o0000ooooooooool0O_ooool00ol0003oooooooooo`19ooooo`03
o`000?oooooooooo013ooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool03?ooool002Gooooo00?o0000oooooooo
ool0O_ooool00ol0003oooooooooo`19ooooo`;o00004Oooool01?l0003oooooooooool0000;oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03oooool2o`0000oooooo000Uooooo`03
o`000?oooooooooo07kooooo00?o0000ooooooooool0BOooool00ol0003oooooooooo`0@ooooo`04
o`000?ooooooooooo`0000Oooooo1?l0000Booooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool01oooool4o`00017ooooo00Go0000ooooooooooooooooo`00000?ooooo`05o`000?oooooo
ooooooooool000000oooool01?l0003oooooooooooooool4o`0001Cooooo00?o0000ooooooooool0
3?ooool002Gooooo00?o0000ooooooooool04?ooool2o`0000Cooooo00?o0000ooooooooool00_oo
ool3o`00017ooooo0ol0000Aooooo`?o00001?ooool00ol0003oooooooooo`02ooooo`?o00004?oo
ool5o`00013ooooo1Ol00002ooooo`;o00001?ooool3o`00017ooooo0ol0000_ooooo`03o`000?oo
oooooooo013ooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0Booooo`;o0000
4_ooool2o`0000Wooooo00?o0000ooooooooool04_ooool01Ol0003ooooooooooooooooo000000oo
oooo00Go0000ooooooooooooooooo`000003ooooo`05o`000?ooooooooooooooool000004oooool0
1Ol0003ooooooooooooooooo000000kooooo000Uooooo`03o`000?oooooooooo00oooooo00Co0000
oooooooooooo00001oooool01Ol0003ooooooooooooooooo0000017ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool000004?ooool01?l0003o
ooooooooool0000Aooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00_ooool0
1Ol0003ooooooooooooooooo000000oooooo00Go0000ooooooooooooooooo`00000^ooooo`;o0000
4_ooool2o`0000Sooooo1Ol0000Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
1oooool5o`00017ooooo0ol0000Aooooo`?o00000oooool00ol0003oooooooooo`02ooooo`Go0000
4?ooool3o`0000oooooo000Uooooo`03o`000?oooooooooo00oooooo00Co0000oooooooooooo0000
2oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01;ooooo00Go0000oooooooooooo
ooooo`000009ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0;?ooool00ol0003o
ooooooooo`1oooooo`03o`000?oooooooooo02Wooooo000Uooooo`03o`000?oooooooooo00oooooo
00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01;o
oooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`0?ooooo`;o0000;oooool00ol0
003oooooooooo`1oooooo`03o`000?oooooooooo02Wooooo000Uooooo`03o`000?oooooooooo00oo
oooo00Co0000oooooooooooo00001oooool4o`0001;ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`07ooooo`Co00004?ooool01Ol0003ooooooooooooooooo0000013ooooo00Oo0000
ooooooooooooooooo`000?oooooo000000Gooooo1?l0000Dooooo`03o`000?oooooooooo02cooooo
00?o0000ooooooooool0C?ooool2o`00037ooooo00?o0000ooooooooool0:Oooool002Gooooo00?o
0000ooooooooool03oooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo01;ooooo
0_l0000Booooo`;o00002Oooool00ol0003oooooooooo`0Aooooo`05o`000?ooooooooooooooool0
00004?ooool01ol0003ooooooooooooooooo0000ooooool000001Oooool00ol0003oooooooooo`0A
ooooo`05o`000?ooooooooooooooool00000;_oooonOo`0000oooooo000Uooooo`03o`000?oooooo
oooo013ooooo0_l00008ooooo`Go00004Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo00Oooooo1Ol0000@ooooo`?o00004_ooool3o`0000;ooooo00?o0000ooooooooool00oooool5
o`00013ooooo0ol0000_ooooo`03o`000?oooooooooo00Sooooo0ol0000=ooooo`03o`000?oooooo
oooo01Oooooo00?o0000ooooooooool01Oooool7o`0000_ooooo00?o0000ooooooooool02oooool6
o`0000Oooooo00?o0000ooooooooool05?ooool01?l0003oooooooooool0000Iooooo`03o`000?oo
oooooooo00gooooo000Uooooo`03o`000?oooooooooo07gooooo00?o0000ooooooooool0B_ooool0
0ol0003oooooooooo`0;ooooo`Co00009oooool4o`0002Kooooo1Ol0000Iooooo`03o`000?oooooo
oooo02[ooooo000Uooooo`03o`000?oooooooooo07gooooo00?o0000ooooooooool0B_ooool2o`00
013ooooo0_l0000Rooooo`?o0000;oooool2o`0001Kooooo00?o0000ooooooooool0:oooool002Go
oooo00?o0000ooooooooool0OOooool00ol0003oooooooooo`1:ooooo`03o`000?oooooooooo017o
oooo0_l0001Dooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0:oooool0027ooooo
Y_l0000[ooooo`03o`000?oooooooooo01?ooooo0ol0001Wooooo`03o`000?oooooooooo02_ooooo
000Uooooo`04o`000?ooooooooooooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00?ooooo1_l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool00000
1?l00004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo02gooooo0_l0000Gooooo`03o`000?oooooooooo06?ooooo
00?o0000ooooooooool0;?ooool002Gooooo00?o0000ooooooooool00oooool3o`0003Wooooo0_l0
000Eooooo`;o00009?ooool00ol0003oooooooooo`1;ooooo`03o`000?oooooooooo01Oooooo00?o
0000ooooooooool0H_ooool00ol0003oooooooooo`0/ooooo`009Oooool00ol0003oooooooooo`06
ooooo`;o0000=Oooool2o`0001Wooooo0_l0000Rooooo`03o`000?oooooooooo04_ooooo00?o0000
ooooooooool06?ooool2o`0006;ooooo00?o0000ooooooooool0;?ooool002Gooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`0`ooooo`;o00007Oooool3o`0001oooooo00?o0000oooo
ooooool0Boooool2o`0001_ooooo00?o0000ooooooooool0G_ooool00ol0003oooooooooo`0]oooo
o`009Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo02gooooo0_l0000Rooooo`;o
00007Oooool00ol0003oooooooooo`1;ooooo`03o`000?oooooooooo01_ooooo00?o0000oooooooo
ool0GOooool00ol0003oooooooooo`0]ooooo`009Oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo02_ooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0Jooooo`03o`00
0?oooooooooo04_ooooo00?o0000ooooooooool07?ooool2o`0005gooooo00?o0000ooooooooool0
;Oooool002Gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Zooooo`03o`000?oo
oooooooo02Kooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`1;ooooo`03o`000?oo
oooooooo01kooooo0_l0001Jooooo`03o`000?oooooooooo02kooooo000Uooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool09oooool2o`0002[ooooo00?o0000ooooooooool05oooool0
0ol0003oooooooooo`0jooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00001?ooool2
o`00027ooooo00?o0000ooooooooool0Eoooool00ol0003oooooooooo`0^ooooo`009Oooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo02Cooooo0_l0000]ooooo`;o00005oooool00ol0
003oooooooooo`0iooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00
0003ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool0E_ooool00ol0003ooooooooo
o`0^ooooo`009Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo02;ooooo00?o0000
ooooooooool0;oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo03Wooooo00Co0000
oooooooooooo00002oooool01Ol0003ooooooooooooooooo000002Cooooo00?o0000ooooooooool0
E?ooool00ol0003oooooooooo`0_ooooo`009Oooool00ol0003oooooooooo`0>ooooo`03o`000?oo
oooooooo023ooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0Cooooo`03o`000?oo
oooooooo03Wooooo00Co0000oooooooooooo00002oooool01?l0003oooooooooooooool2o`0002Co
oooo00?o0000ooooooooool0Doooool00ol0003oooooooooo`0_ooooo`009Oooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0<Oooool00ol0003ooooo
ooooo`0Cooooo`03o`000?oooooooooo03Wooooo00Co0000oooooooooooo00001oooool4o`0000Co
oooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo02oo
oooo000Uooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool07oooool00ol0003ooooo
ooooo`0aooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0>Oooool01?l0003ooooo
ooooool00007ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool09Oooool00ol0003o
ooooooooo`1Aooooo`03o`000?oooooooooo02oooooo000Uooooo`03o`000?oooooooooo013ooooo
00?o0000ooooooooool07_ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo01?ooooo
00?o0000ooooooooool0>_ooool2o`0000Sooooo1Ol00003ooooo`;o00009oooool00ol0003ooooo
ooooo`1?ooooo`03o`000?oooooooooo033ooooo000Uooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool07Oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool0C?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo04kooooo00?o
0000ooooooooool0<?ooool001?ooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go00000ooo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0<Ooo
ool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool0:?oo
ool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo033ooooo000Booooo`04o`000?oooooo
ooooo`0000Sooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo01_ooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo04gooooo0_l0000Zooooo`03o`000?oooooooooo04_ooooo00?o0000ooooooooool0
<Oooool001;ooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`03ooooo`;o0000
5?ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0
Boooool00ol0003oooooooooo`0aooooo`004_ooool01?l0003oooooooooool0000:ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Jooooo`03o`00
0?oooooooooo037ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1=ooooo`03o`00
0?oooooooooo02[ooooo00?o0000ooooooooool0B_ooool00ol0003oooooooooo`0aooooo`004_oo
ool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000000oooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool0<Oooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0:oooool2o`0004Wo
oooo00?o0000ooooooooool0<_ooool001;ooooo00Co0000oooooooooooo00001oooool01Ol0003o
oooooooooooooooo000000?ooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0Ioooo
o`03o`000?oooooooooo037ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1=oooo
o`;o0000;_ooool00ol0003oooooooooo`16ooooo`03o`000?oooooooooo03;ooooo000Cooooo`;o
00002Oooool3o`0000Cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Hooooo`03
o`000?oooooooooo037ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1=ooooo`03
o`000?oooooooooo02kooooo00?o0000ooooooooool0A?ooool00ol0003oooooooooo`0cooooo`00
9Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0
<Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0
;_ooool00ol0003oooooooooo`14ooooo`03o`000?oooooooooo03?ooooo000Uooooo`03o`000?oo
oooooooo01Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0aooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0COooool2o`00033ooooo00?o0000ooooooooool0@_oo
ool00ol0003oooooooooo`0dooooo`009Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooo
oooo01Oooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo04Oooooo0ol00004ooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool0@Oooool0
0ol0003oooooooooo`0dooooo`009Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
04Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo
03oooooo00?o0000ooooooooool0=Oooool002Gooooo00?o0000ooooooooool06?ooool00ol0003o
ooooooooo`0Fooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`18ooooo`03o`000?oooooooooo00?ooooo0_l0000cooooo`03o`000?oooooooooo03ko
oooo00?o0000ooooooooool0=Oooool002Gooooo00?o0000ooooooooool06Oooool00ol0003ooooo
ooooo`0Eooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`18ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Loooool00ol0003ooooo
ooooo`0eooooo`009Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo01Gooooo00?o
0000ooooooooool0<Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04Sooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`1booooo`03o`000?oooooooooo03Kooooo000U
ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0a
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0Aoooool2o`0000Gooooo0_l0001c
ooooo`03o`000?oooooooooo03Kooooo000Uooooo`03o`000?oooooooooo01[ooooo00?o0000oooo
ooooool05?ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0B?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo07;ooooo00?o0000oooo
ooooool0=_ooool002Gooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Cooooo`03
o`000?oooooooooo037ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1>ooooo`03
o`000?oooooooooo077ooooo00?o0000ooooooooool0=oooool002Gooooo00?o0000ooooooooool0
6oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`1?ooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool0
=oooool001?ooooo0_l00004ooooo`03o`000?oooooooooo00?ooooo0ol00003ooooo`03o`000?oo
oooooooo01cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0aooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool0Coooool2o`0007;ooooo00?o0000ooooooooool0=ooo
ool001;ooooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo01cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0aooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool0Coooool00ol0003oooooooooo`1`ooooo`03o`000?oo
oooooooo03Sooooo000Booooo`04o`000?ooooooooooo`0000Oooooo1Ol00003ooooo`03o`000?oo
oooooooo01gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0aooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool0Coooool00ol0003oooooooooo`1`ooooo`03o`000?oo
oooooooo03Sooooo000Booooo`04o`000?ooooooooooo`0000Oooooo00Co0000oooooooooooo0000
1?ooool2o`0001kooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0aooooo`03o`00
0?oooooooooo013ooooo00?o0000ooooooooool0Coooool2o`00077ooooo00?o0000ooooooooool0
>?ooool001;ooooo00Co0000oooooooooooo00002?ooool00ol0003oooooo`000004ooooo`03o`00
0?oooooooooo01kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0aooooo`03o`00
0?oooooooooo013ooooo00?o0000ooooooooool0Coooool00ol0003oooooooooo`1_ooooo`03o`00
0?oooooooooo03Wooooo000Booooo`04o`000?ooooooooooo`0000Wooooo0_l00004ooooo`03o`00
0?oooooooooo01kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0aooooo`03o`00
0?oooooooooo013ooooo00?o0000ooooooooool0Coooool00ol0003oooooooooo`1_ooooo`03o`00
0?oooooooooo03Wooooo000Cooooo`;o00002oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo01oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0aooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool0Coooool2o`00073ooooo00?o0000ooooooooool0>Ooo
ool002Gooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo037ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0looooo`?o00001?ooool0
0ol0003oooooooooo`02ooooo`?o00001?ooool00ol0003oooooooooo`1^ooooo`03o`000?oooooo
oooo03[ooooo000Uooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0aooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0?_ooool00ol0
003oooooooooo`07ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`1^
ooooo`03o`000?oooooooooo03[ooooo000Uooooo`03o`000?oooooooooo023ooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool0?_ooool00ol0003oooooooooo`0;ooooo`04o`000?ooooooooooooooo`;o0000K_ooool0
0ol0003oooooooooo`0kooooo`009Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo
00gooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
03kooooo00?o0000ooooooooool02oooool01Ol0003ooooooooooooooooo000006oooooo00?o0000
ooooooooool0>oooool002Gooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo037ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0noooo
o`03o`000?oooooooooo00Oooooo1?l00004ooooo`03o`000?oooooooooo06gooooo00?o0000oooo
ooooool0>oooool002Gooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo037ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0mooooo`;o
00002Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo06cooooo00?o0000oooooooo
ool0??ooool002Gooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo037ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0nooooo`03o`00
0?oooooooooo00Oooooo1Ol00003ooooo`;o0000KOooool00ol0003oooooooooo`0looooo`009Ooo
ool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0<Ooo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo053ooooo00?o0000ooooooooool0K?oo
ool00ol0003oooooooooo`0looooo`009Oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo053ooooo00?o0000ooooooooool0Joooool00ol0003oooooooooo`0mooooo`009Oooool00ol0
003oooooooooo`0Sooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0<Oooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo057ooooo0_l0001/ooooo`03o`000?oooooooooo
03gooooo000Uooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0aooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0DOooool00ol0003o
ooooooooo`1Zooooo`03o`000?oooooooooo03kooooo000Uooooo`03o`000?oooooooooo02?ooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo00kooooo
00?o0000ooooooooool0DOooool00ol0003oooooooooo`1Zooooo`03o`000?oooooooooo03kooooo
000Cooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00001?ooool00ol0003ooooooooo
o`0Tooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0<Oooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo057ooooo0_l0001Zooooo`03o`000?oooooooooo03oooooo000B
ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000003ooooo`03o`00
0?oooooooooo02Cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0aooooo`03o`00
0?oooooooooo00kooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`1Yooooo`03o`00
0?oooooooooo03oooooo000Booooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooooooo
ooooo`000003ooooo`;o00009_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo037o
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo06So
oooo00?o0000ooooooooool0@?ooool001;ooooo00Co0000oooooooooooo00001oooool4o`0000Co
oooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo037o
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`1Aooooo`;o0000JOooool00ol0003o
ooooooooo`10ooooo`004_ooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo037o
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`19ooooo`Go00000oooool00ol0003o
ooooooooo`1Xooooo`03o`000?oooooooooo043ooooo000Booooo`04o`000?ooooooooooo`0000So
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo04[o
oooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`1Wooooo`03o`000?oooooooooo
047ooooo000Cooooo`;o00002_ooool2o`0000Cooooo00?o0000ooooooooool09_ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`1<ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Zoooool002Gooooo
00?o0000ooooooooool09oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo037ooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo00;ooooo
0_l0002/ooooo`009Oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool0<Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo04[ooooo00Go
0000ooooooooooooooooo`00002aooooo`009Oooool00ol0003oooooooooo`0Wooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0=ooooo`03o`000?oo
oooooooo04[ooooo00Go0000ooooooooooooooooo`00002aooooo`009Oooool00ol0003ooooooooo
o`0Xooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0<Oooool00ol0003ooooooooo
o`0=ooooo`03o`000?oooooooooo04_ooooo0ol0002booooo`00oooooonQooooo`00oooooonQoooo
o`00oooooonQooooo`00oooooonQooooo`00oooooonQooooo`00oooooonQooooo`00oooooonQoooo
o`00oooooonQooooo`00\
\>"],
  ImageRangeCache->{{{0, 415}, {121.375, 0}} -> {-0.0565703, -0.0147151, \
0.00509191, 0.00509191}, {{11.0625, 198.125}, {118.438, 2.875}} -> \
{-0.709064, -0.54066, 0.0190995, 0.0108448}, {{216.812, 403.875}, {118.438, \
2.875}} -> {-4.60746, -1.36442, 0.0189772, 0.0307057}}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Plot Discontinuous function, II"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[
"Define function f[x] using UnitStep and Unit Pulse"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(fp[t_] := 
      t\^2\ UnitPulse[t, 0, 1] + 
        1\/2\ \((t - 3\/2)\)\^2\ UnitPulse[t, 1, 
            2] + \((6 - t\^2)\)\ UnitStep[t - 2]\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Plot again (Note vertical lines are back)"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p5 = 
        Plot[Evaluate[fp[t]], {t, 0, 3}, 
          PlotRange \[Rule] {\(-1\), 2}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.206011 0.206011 [
[.18254 .19351 -9 -9 ]
[.18254 .19351 9 0 ]
[.34127 .19351 -3 -9 ]
[.34127 .19351 3 0 ]
[.5 .19351 -9 -9 ]
[.5 .19351 9 0 ]
[.65873 .19351 -3 -9 ]
[.65873 .19351 3 0 ]
[.81746 .19351 -9 -9 ]
[.81746 .19351 9 0 ]
[.97619 .19351 -3 -9 ]
[.97619 .19351 3 0 ]
[.01131 0 -12 -4.5 ]
[.01131 0 0 4.5 ]
[.01131 .10301 -24 -4.5 ]
[.01131 .10301 0 4.5 ]
[.01131 .30902 -18 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .41202 -6 -4.5 ]
[.01131 .41202 0 4.5 ]
[.01131 .51503 -18 -4.5 ]
[.01131 .51503 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .20601 m
.18254 .21226 L
s
[(0.5)] .18254 .19351 0 1 Mshowa
.34127 .20601 m
.34127 .21226 L
s
[(1)] .34127 .19351 0 1 Mshowa
.5 .20601 m
.5 .21226 L
s
[(1.5)] .5 .19351 0 1 Mshowa
.65873 .20601 m
.65873 .21226 L
s
[(2)] .65873 .19351 0 1 Mshowa
.81746 .20601 m
.81746 .21226 L
s
[(2.5)] .81746 .19351 0 1 Mshowa
.97619 .20601 m
.97619 .21226 L
s
[(3)] .97619 .19351 0 1 Mshowa
.125 Mabswid
.05556 .20601 m
.05556 .20976 L
s
.0873 .20601 m
.0873 .20976 L
s
.11905 .20601 m
.11905 .20976 L
s
.15079 .20601 m
.15079 .20976 L
s
.21429 .20601 m
.21429 .20976 L
s
.24603 .20601 m
.24603 .20976 L
s
.27778 .20601 m
.27778 .20976 L
s
.30952 .20601 m
.30952 .20976 L
s
.37302 .20601 m
.37302 .20976 L
s
.40476 .20601 m
.40476 .20976 L
s
.43651 .20601 m
.43651 .20976 L
s
.46825 .20601 m
.46825 .20976 L
s
.53175 .20601 m
.53175 .20976 L
s
.56349 .20601 m
.56349 .20976 L
s
.59524 .20601 m
.59524 .20976 L
s
.62698 .20601 m
.62698 .20976 L
s
.69048 .20601 m
.69048 .20976 L
s
.72222 .20601 m
.72222 .20976 L
s
.75397 .20601 m
.75397 .20976 L
s
.78571 .20601 m
.78571 .20976 L
s
.84921 .20601 m
.84921 .20976 L
s
.88095 .20601 m
.88095 .20976 L
s
.9127 .20601 m
.9127 .20976 L
s
.94444 .20601 m
.94444 .20976 L
s
.25 Mabswid
0 .20601 m
1 .20601 L
s
.02381 0 m
.03006 0 L
s
[(-1)] .01131 0 1 0 Mshowa
.02381 .10301 m
.03006 .10301 L
s
[(-0.5)] .01131 .10301 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(0.5)] .01131 .30902 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(1)] .01131 .41202 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(1.5)] .01131 .51503 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(2)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0206 m
.02756 .0206 L
s
.02381 .0412 m
.02756 .0412 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .0824 m
.02756 .0824 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .14421 m
.02756 .14421 L
s
.02381 .16481 m
.02756 .16481 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26781 m
.02756 .26781 L
s
.02381 .28842 m
.02756 .28842 L
s
.02381 .32962 m
.02756 .32962 L
s
.02381 .35022 m
.02756 .35022 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .45322 m
.02756 .45322 L
s
.02381 .47383 m
.02756 .47383 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .53563 m
.02756 .53563 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57683 m
.02756 .57683 L
s
.02381 .59743 m
.02756 .59743 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .20601 m
.02499 .20601 L
.02605 .20602 L
.02729 .20604 L
.02846 .20606 L
.03053 .2061 L
.03279 .20618 L
.03527 .20628 L
.0379 .20642 L
.04262 .20673 L
.04749 .20716 L
.05205 .20764 L
.06244 .20906 L
.07305 .21097 L
.08274 .21311 L
.10458 .21935 L
.12357 .22635 L
.14429 .23568 L
.18493 .25908 L
.22406 .28799 L
.26565 .32556 L
.28651 .34708 L
.30571 .36846 L
.32446 .39078 L
.3339 .40257 L
.33649 .40586 L
.33791 .40769 L
.33926 .40942 L
.34051 .41104 L
.34122 .41196 L
.34188 .23157 L
.34303 .23119 L
.34426 .2308 L
.38201 .22024 L
.40299 .21563 L
.42222 .2122 L
.44106 .20956 L
.45066 .2085 L
.4609 .20757 L
.47125 .20686 L
.48065 .20639 L
.48518 .20624 L
.48757 .20617 L
.49009 .20611 L
.4923 .20607 L
.49347 .20605 L
.49473 .20604 L
.49589 .20603 L
.49694 .20602 L
.49801 .20602 L
Mistroke
.49901 .20601 L
.50026 .20601 L
.50097 .20601 L
.50161 .20601 L
.5028 .20602 L
.50406 .20603 L
.50518 .20604 L
.50624 .20605 L
.50862 .20609 L
.51121 .20614 L
.51357 .2062 L
.51886 .20637 L
.52339 .20657 L
.52831 .20683 L
.53726 .20743 L
.54668 .20824 L
.55707 .20934 L
.57809 .21224 L
.59748 .21572 L
.61835 .22033 L
.63843 .2256 L
.64852 .22856 L
.65128 .2294 L
.65423 .23032 L
.65566 .23078 L
.65701 .23121 L
.65823 .2316 L
.65954 .61593 L
.66078 .61271 L
.66191 .60977 L
.66445 .60313 L
.66903 .59108 L
.67945 .56336 L
.70051 .50602 L
.74032 .39263 L
.77862 .27745 L
.81937 .1483 L
.8586 .01755 L
Mfstroke
.8586 .01755 m
.86363 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{214.875, 132.812},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003F0000Q2000`400?l00000o`00003oe_ooool0
0=Kooooo003Fooooo`00e_ooool001?ooooo0ol00030ooooo`005?ooool00ol0003oooooooooo`2o
ooooo`003?ooool5o`0000?ooooo00?o0000ooooooooool00oooool2o`0009oooooo00?o0000oooo
ooooool06?ooool001Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Nooooo`03
o`000?oooooooooo01Sooooo000Dooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
W_ooool00ol0003oooooooooo`0Hooooo`004oooool2o`0000Gooooo00?o0000ooooooooool0WOoo
ool00ol0003oooooooooo`0Iooooo`005?ooool00ol0003oooooooooo`03ooooo`;o0000W_ooool0
0ol0003oooooooooo`0Iooooo`006_ooool00ol0003oooooooooo`2Mooooo`03o`000?oooooooooo
01Wooooo000Jooooo`03o`000?oooooooooo09gooooo00?o0000ooooooooool06Oooool001[ooooo
00?o0000ooooooooool0W?ooool00ol0003oooooooooo`0Jooooo`006_ooool2o`0009gooooo00?o
0000ooooooooool06_ooool001[ooooo00?o0000ooooooooool0W?ooool00ol0003oooooooooo`0J
ooooo`006_ooool00ol0003oooooooooo`2Kooooo`03o`000?oooooooooo01_ooooo000Jooooo`03
o`000?oooooooooo09_ooooo00?o0000ooooooooool06oooool001[ooooo0_l0002Looooo`03o`00
0?oooooooooo01_ooooo000Jooooo`03o`000?oooooooooo09_ooooo00?o0000ooooooooool06ooo
ool001[ooooo00?o0000ooooooooool0V_ooool00ol0003oooooooooo`0Looooo`006_ooool00ol0
003oooooooooo`2Jooooo`03o`000?oooooooooo01cooooo000Jooooo`;o0000Voooool00ol0003o
ooooooooo`0Looooo`006_ooool00ol0003oooooooooo`2Iooooo`03o`000?oooooooooo01gooooo
0008ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00001?ooool00ol0003ooooooooo
o`2Iooooo`03o`000?oooooooooo01gooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00Go
0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo09Wooooo00?o0000ooooooooool0
7Oooool000Go00000_ooool01?l0003oooooooooool0000;ooooo`04o`000?ooooooooooooooo`;o
0000V_ooool00ol0003oooooooooo`0Mooooo`001oooool01?l0003oooooooooool0000;ooooo`05
o`000?ooooooooooooooool00000V_ooool00ol0003oooooooooo`0Nooooo`001oooool01?l0003o
ooooooooool00007ooooo`Co00001?ooool00ol0003oooooooooo`2Hooooo`03o`000?oooooooooo
01kooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`2Hooooo`03o`000?oooooooooo01kooooo0008ooooo`;o00002?ooool5o`0000?o
oooo0_l0002Iooooo`03o`000?oooooooooo01kooooo000Jooooo`03o`000?oooooooooo09Oooooo
00?o0000ooooooooool07oooool001[ooooo00?o0000ooooooooool0Uoooool00ol0003ooooooooo
o`0Oooooo`006_ooool00ol0003oooooooooo`2Gooooo`03o`000?oooooooooo01oooooo000Joooo
o`;o0000Uoooool00ol0003oooooooooo`0Pooooo`006_ooool00ol0003oooooooooo`0Dooooo`;o
00001?ooool00ol0003oooooooooo`02ooooo`?o00005_ooool3o`0001Gooooo0ol00004ooooo`03
o`000?oooooooooo00;ooooo0ol0000Eooooo`Go00004oooool5o`0000?ooooo00?o0000ooooool0
00000_ooool3o`0001Kooooo0ol00004ooooo`006_ooool00ol0003oooooooooo`0Cooooo`04o`00
0?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Fooooo`03o`000?oooooooooo
01Gooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000001Gooooo00Co0000
oooooooooooo00005?ooool01?l0003oooooooooool00005ooooo`03o`000?oooooo000000?ooooo
00?o0000ooooooooool04_ooool01Ol0003ooooooooooooooooo000000?ooooo000Jooooo`03o`00
0?oooooooooo01?ooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0Dooooo`03
o`000?oooooooooo01Gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Dooooo`03
o`000?oooooooooo01Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo01Kooooo00?o0000ooooooooool00Oooool001[ooooo0_l0000Dooooo`04o`00
0?ooooooooooo`0000_ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Eooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0Eooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Dooooo`;o
00001?ooool001[ooooo00?o0000ooooooooool04oooool01?l0003oooooooooool00007ooooo`Co
00005oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00Oooooo1?l0000Eooooo`05
o`000?ooooooooooooooool000004oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000
ooooooooool01?l0000Iooooo`03o`000?oooooooooo007ooooo000Jooooo`03o`000?oooooooooo
01?ooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0Gooooo`;o00005_ooool2
o`0000Wooooo00?o0000ooooooooool05_ooool01Ol0003ooooooooooooooooo000001?ooooo00Go
0000ooooooooooooooooo`000004ooooo`04o`000?ooooooooooo`0001Sooooo00Go0000oooooooo
ooooooooo`000003ooooo`006_ooool00ol0003oooooooooo`0Dooooo`;o00002?ooool5o`0001Ko
oooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`07ooooo`Go00005Oooool3o`0001Go
oooo0ol00004ooooo`04o`000?ooooooooooooooo`Go00005Oooool3o`0000Cooooo000Jooooo`;o
0000UOooool00ol0003oooooooooo`0Rooooo`006_ooool00ol0003oooooooooo`2Dooooo`03o`00
0?oooooooooo02;ooooo000Jooooo`03o`000?oooooooooo09?ooooo00?o0000ooooooooool08ooo
ool001[ooooo00?o0000ooooooooool0Toooool00ol0003oooooooooo`0Sooooo`005Oooooo1o`00
00006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Go00001?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003o
ooooo`000002o`000003ooooool0003ooooo00Cooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Cooooo1Ol000000ooooooo0000ooooo`04ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02oooo
o`006_ooool00ol0003oooooooooo`0;ooooo`?o0000=_ooool4o`0002;ooooo1?l0000Tooooo`03
o`000?oooooooooo02Cooooo000Jooooo`03o`000?oooooooooo00kooooo0_l0000`ooooo`Co0000
:_ooool4o`00023ooooo00?o0000ooooooooool09?ooool001[ooooo0_l0000Aooooo`;o0000:_oo
ool4o`0003;ooooo1Ol0000Jooooo`03o`000?oooooooooo02Gooooo000Jooooo`03o`000?oooooo
oooo01;ooooo0_l0000Vooooo`;o0000>_ooool2o`0001Wooooo00?o0000ooooooooool09Oooool0
01[ooooo00?o0000ooooooooool05?ooool2o`0002Cooooo00?o0000ooooooooool0>_ooool00ol0
003oooooooooo`0Gooooo`03o`000?oooooooooo02Gooooo000Jooooo`03o`000?oooooooooo01Ko
oooo0_l0000Rooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool05_ooool00ol0003o
ooooooooo`0Vooooo`006_ooool2o`0001Wooooo0_l0000Pooooo`03o`000?oooooooooo03[ooooo
00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Vooooo`006_ooool00ol0003ooooooooo
o`0Jooooo`;o00007_ooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo01Kooooo00?o
0000ooooooooool09_ooool001[ooooo00?o0000ooooooooool07?ooool2o`0001cooooo00?o0000
ooooooooool0>_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo02Oooooo000Joooo
o`03o`000?oooooooooo01kooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0joooo
o`03o`000?oooooooooo01Gooooo00?o0000ooooooooool09oooool001[ooooo0_l0000Pooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0Eooooo`03
o`000?oooooooooo02Oooooo000Jooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0
5oooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0
:?ooool001[ooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`0Fooooo`03o`000?oo
oooooooo03[ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Xooooo`006_ooool0
0ol0003oooooooooo`0Rooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0>_ooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooooooo02Sooooo000Jooooo`;o00009?ooool2o`00
01Gooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo
02Sooooo0008ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00001?ooool00ol0003o
ooooooooo`0Uooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0>_ooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo02Wooooo0007ooooo`04o`000?ooooooooooo`0000Oo
oooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo02Kooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo01?ooooo00?o0000oooo
ooooool0:Oooool000Oooooo00Co0000oooooooooooo00002oooool01Ol0003ooooooooooooooooo
000002Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0jooooo`03o`000?oooooo
oooo01?ooooo00?o0000ooooooooool0:Oooool000Oooooo00Co0000oooooooooooo00002oooool0
1?l0003oooooooooooooool2o`0002Wooooo00?o0000ooooooooool03oooool00ol0003ooooooooo
o`0jooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0:_ooool000Oooooo00Co0000
oooooooooooo00001oooool4o`0000Cooooo00?o0000ooooooooool0:Oooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Zooooo`001oooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool0:_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo03[ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`0Zooooo`002?ooool2o`0000Sooooo1Ol00003
ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0j
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0:oooool001[ooooo0_l0000]oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo02_ooooo000Jooooo`03o`000?oooooooooo02gooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool0:oooool001[ooooo00?o0000ooooooooool0;_ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo03[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0/ooooo`006_oo
ool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0>_oo
ool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo02cooooo000Jooooo`;o0000<Oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0/ooooo`006_ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
02gooooo000Jooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0jooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0;Oooool001[ooooo
0_l0000dooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0>_ooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo02gooooo000Jooooo`03o`000?oooooooooo03Cooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo00kooooo00?o
0000ooooooooool0;_ooool001[ooooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0^
ooooo`006_ooool00ol0003oooooooooo`0fooooo`05o`000?ooooooooooooooool00000??ooool0
0ol0003oooooooooo`0>ooooo`03o`000?oooooooooo02kooooo000Jooooo`;o0000>?ooool01?l0
003oooooooooool0000looooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0;oooool0
01[ooooo00?o0000ooooooooool0=oooool01?l0003oooooooooool0000looooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool0;oooool001?ooooo0ol00004ooooo`03o`000?oooooooooo
03Sooooo00?o0000ooooool00000??ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
02oooooo000Dooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0>?ooool3o`0003co
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0`ooooo`005?ooool00ol0003ooooo
ooooo`03ooooo`;o0000>_ooool2o`0003cooooo00?o0000ooooooooool03?ooool00ol0003ooooo
ooooo`0`ooooo`005?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo07Oooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`0`ooooo`005?ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo07Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0a
ooooo`004oooool2o`0000Gooooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo037ooooo000Dooooo`03o`000?oooooooooo00?ooooo0_l0001hooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool0<Oooool001[ooooo00?o0000ooooooooool0
Moooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo03;ooooo000Jooooo`03o`000?oo
oooooooo07Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0booooo`006_ooool0
0ol0003oooooooooo`1gooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0<oooool0
01[ooooo0_l0001hooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0<oooool001[o
oooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo03?o
oooo000Jooooo`03o`000?oooooooooo07Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`0dooooo`006_ooool00ol0003oooooooooo`1gooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool0=?ooool001[ooooo0_l0001hooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool0=Oooool001[ooooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo03Gooooo000Jooooo`03o`000?oooooooooo07Oooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`0eooooo`006_ooool00ol0003oooooooooo`1gooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool0=_ooool001[ooooo0_l0001hooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool0=_ooool001[ooooo00?o0000ooooooooool0Moooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo03Kooooo0007ooooo`?o00001?ooool00ol0
003oooooooooo`02ooooo`?o00001?ooool00ol0003oooooooooo`1gooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool0=oooool000Sooooo00?o0000ooooooooool01oooool01Ol0003o
oooooooooooooooo000000?ooooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo03Oooooo0008ooooo`03o`000?oooooooooo00_ooooo00Co0000oooooooo
oooooooo0_l0001hooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0>?ooool000So
oooo00?o0000ooooooooool02oooool01Ol0003ooooooooooooooooo000007Wooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0hooooo`002?ooool00ol0003oooooooooo`07ooooo`Co
00001?ooool00ol0003oooooooooo`1gooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0>?ooool000Oooooo0_l00009ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
Moooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo03Wooooo0008ooooo`03o`000?oo
oooooooo00Oooooo1Ol00003ooooo`;o0000N?ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo03Wooooo000Jooooo`03o`000?oooooooooo07Oooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`0iooooo`006_ooool00ol0003oooooooooo`1gooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool0>_ooool001[ooooo00?o0000ooooooooool0Moooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo03[ooooo000Jooooo`;o0000N?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo03[ooooo000Jooooo`03o`000?oooooooooo07Oooooo00Go
0000ooooooooooooooooo`00000mooooo`006_ooool00ol0003oooooooooo`1gooooo`05o`000?oo
ooooooooooooool00000?Oooool001[ooooo00?o0000ooooooooool0Moooool01?l0003ooooooooo
ool0000nooooo`006_ooool2o`0007Sooooo00Co0000oooooooooooo0000?_ooool001[ooooo00?o
0000ooooooooool0Moooool01?l0003oooooooooool0000nooooo`006_ooool00ol0003ooooooooo
o`1gooooo`03o`000?oooooo000003oooooo000Jooooo`03o`000?oooooooooo07Oooooo00?o0000
ooooool00000?oooool001[ooooo0_l0001hooooo`03o`000?oooooo000003oooooo000Booooo`Go
00000oooool00ol0003oooooooooo`1gooooo`;o0000@?ooool001?ooooo00Co0000oooooooooooo
00000oooool00ol0003oooooooooo`1gooooo`03o`000?oooooooooo03oooooo000Dooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`0oooooo`005Ooo
ool00ol0003oooooooooo`02ooooo`;o0000N?ooool00ol0003oooooooooo`0oooooo`004_ooool0
1Ol0003ooooooooooooooooo00000;oooooo000Booooo`05o`000?ooooooooooooooool00000_ooo
ool001?ooooo0ol00030ooooo`00e_ooool00=Kooooo003Fooooo`00\
\>"],
  ImageRangeCache->{{{0, 213.875}, {131.812, 0}} -> {-0.433047, -1.16585, \
0.0164024, 0.0252759}}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Plot UnitStep[Sin[2t]]*Sin[2t]"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[UnitStep[Sin[2\ t]]\ Sin[2\ t], {t, 0, 4\ \[Pi]}, 
        AspectRatio \[Rule] 2\/12, 
        Ticks \[Rule] {{\[Pi], 2\ \[Pi], 3\ \[Pi], 4\ \[Pi]}, {{1, 1}}}, 
        PlotRange \[Rule] {{0, 4\ \[Pi]}, {0, 1.1}}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .16667 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.0795775 0 0.151515 [
[.25 -0.0125 -5 -12 ]
[.25 -0.0125 5 0 ]
[.5 -0.0125 -9.3125 -12 ]
[.5 -0.0125 9.3125 0 ]
[.75 -0.0125 -9.3125 -12 ]
[.75 -0.0125 9.3125 0 ]
[1 -0.0125 -9.3125 -12 ]
[1 -0.0125 9.3125 0 ]
[-0.0125 .15152 -6 -4.5 ]
[-0.0125 .15152 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .16667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.25 0 m
.25 .00625 L
s
gsave
.25 -0.0125 -66 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding MacintoshRomanEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
1.000 setlinewidth
grestore
.5 0 m
.5 .00625 L
s
gsave
.5 -0.0125 -70.3125 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding MacintoshRomanEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
71.625 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
1.000 setlinewidth
grestore
.75 0 m
.75 .00625 L
s
gsave
.75 -0.0125 -70.3125 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding MacintoshRomanEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
71.625 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
1.000 setlinewidth
grestore
1 0 m
1 .00625 L
s
gsave
1 -0.0125 -70.3125 -16 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding MacintoshRomanEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
71.625 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
s
0 .15152 m
.00625 .15152 L
s
[(1)] -0.0125 .15152 1 0 Mshowa
0 0 m
0 .16667 L
s
0 0 m
1 0 L
1 .16667 L
0 .16667 L
closepath
clip
newpath
.5 Mabswid
0 0 m
.01975 .07215 L
.02981 .10318 L
.04057 .12907 L
.04629 .13912 L
.0515 .14576 L
.05401 .14808 L
.05533 .14906 L
.05673 .14993 L
.05796 .15053 L
.05931 .15103 L
.06053 .15133 L
.06168 .15148 L
.06242 .15151 L
.06311 .1515 L
.06386 .15143 L
.06466 .15129 L
.06543 .1511 L
.06615 .15088 L
.0675 .15032 L
.06883 .1496 L
.07006 .14879 L
.07282 .14644 L
.0756 .14337 L
.07865 .1392 L
.08481 .12832 L
.09552 .10226 L
.10529 .07201 L
.1167 .03137 L
.12172 .01249 L
.12309 .00726 L
.12381 .00452 L
.12457 .00163 L
.12524 0 L
.12597 0 L
.12725 0 L
.13697 0 L
.14729 0 L
.16909 0 L
.19141 0 L
.21168 0 L
.2218 0 L
.23277 0 L
.2378 0 L
.24313 0 L
.24532 0 L
.24768 0 L
.24903 0 L
.25026 .00099 L
.2515 .00571 L
Mistroke
.25268 .01019 L
.27375 .08517 L
.28293 .11155 L
.29284 .13338 L
.29554 .13796 L
.29839 .14209 L
.30104 .14527 L
.3035 .14766 L
.30581 .14938 L
.30711 .15013 L
.30829 .15067 L
.30958 .15111 L
.31031 .15129 L
.31098 .1514 L
.31222 .15151 L
.31353 .15146 L
.31489 .15124 L
.31614 .15088 L
.31751 .15032 L
.31894 .14953 L
.32137 .14777 L
.32401 .14522 L
.33 .13709 L
.33557 .12676 L
.34665 .09906 L
.35709 .06592 L
.3664 .03251 L
.37133 .01396 L
.37275 .00857 L
.3741 .00344 L
.3753 0 L
.37662 0 L
.38191 0 L
.38686 0 L
.39768 0 L
.41706 0 L
.43739 0 L
.45985 0 L
.47007 0 L
.48109 0 L
.48616 0 L
.4915 0 L
.49606 0 L
.49731 0 L
.49864 0 L
.4999 0 L
.50105 .00399 L
.52286 .08235 L
.53245 .11031 L
.53753 .12264 L
Mistroke
.543 .13367 L
.54828 .14194 L
.55079 .145 L
.55311 .14732 L
.55544 .14913 L
.55677 .14995 L
.55797 .15054 L
.55912 .15097 L
.56021 .15126 L
.56135 .15145 L
.56259 .15151 L
.56389 .15142 L
.5651 .15119 L
.56643 .15078 L
.56785 .15015 L
.56934 .14928 L
.57076 .14826 L
.5734 .14586 L
.57817 .13992 L
.58335 .13118 L
.59323 .10853 L
.60413 .07588 L
.61564 .03531 L
.62068 .01641 L
.62335 .00629 L
.62411 .00337 L
.62484 .00061 L
.62619 0 L
.62748 0 L
.62866 0 L
.63133 0 L
.6361 0 L
.64652 0 L
.66843 0 L
.70982 0 L
.73062 0 L
.73972 0 L
.74452 0 L
.74715 0 L
.74844 0 L
.74962 0 L
.751 .0038 L
.75248 .00944 L
.75507 .01924 L
.76011 .03808 L
.77006 .07319 L
.78142 .10759 L
.78696 .12136 L
.792 .13185 L
.79692 .14005 L
Mistroke
.80158 .14584 L
.80413 .14818 L
.80649 .14979 L
.80772 .15042 L
.80908 .15095 L
.80976 .15116 L
.81049 .15132 L
.81182 .15149 L
.81252 .15152 L
.81326 .15149 L
.8146 .1513 L
.81542 .15111 L
.81619 .15086 L
.81763 .15026 L
.81902 .14949 L
.82029 .14862 L
.82316 .14611 L
.82821 .13986 L
.83354 .13082 L
.84348 .10785 L
.85415 .07581 L
.86415 .04082 L
.86854 .02448 L
.87088 .01567 L
.8734 .0061 L
.87407 .00352 L
.87479 .0008 L
.87607 0 L
.87726 0 L
.87857 0 L
.88407 0 L
.89569 0 L
.91681 0 L
.95939 0 L
1 0 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{408, 68},
  ImageMargins->{{6, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006H0000A2000`400?l00000o`00003ooooooonI
ooooo`00oooooonIooooo`00oooooonIooooo`00oooooonIooooo`00O?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo043ooooo1Ol00004ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0?Oooool3o`0000Cooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`0nooooo`?o00001?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02[ooooo001m
ooooo`04o`000?ooooooooooo`0004Cooooo00Co0000oooooooooooo00001Oooool01?l0003ooooo
ooooool0000oooooo`05o`000?ooooooooooooooool000001?ooool01?l0003oooooooooool00012
ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo0000;Oooool007kooooo00?o0000
ooooool00000AOooool00ol0003oooooooooo`06ooooo`03o`000?oooooo000004?ooooo00?o0000
ooooooooool00oooool00ol0003oooooo`00000oooooo`Go00001_ooool00ol0003oooooo`00000]
ooooo`00O_ooool00ol0003oooooo`000016ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ool00000@Oooool2o`0000Kooooo00?o0000ooooool00000?oooool01?l0003oooooooooool00007
ooooo`03o`000?oooooo000002gooooo001mooooo`Go0000@_ooool01Ol0003ooooooooooooooooo
000000Gooooo1Ol00012ooooo`03o`000?oooooooooo00;ooooo1Ol0000oooooo`03o`000?oooooo
000000Kooooo1Ol0000/ooooo`00a?ooool01Ol0003ooooooooooooooooo000004Sooooo00Go0000
ooooooooooooooooo`000019ooooo`;o0000=oooool00<Gooooo0ol0001:ooooo`?o0000Boooool0
0ol0003oooooooooo`0eooooo`00oooooonIooooo`00oooooonIooooo`00oooooonIooooo`00oooo
oonIooooo`00oooooonIooooo`00<_ooooooo`0003Go0000<_ooool003;ooooo00?o0000oooooooo
ool08oooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo02?ooooo00?o0000oooooooo
ool08oooool00ol0003oooooooooo`0Sooooo`;o00009Oooool00ol0003oooooooooo`0Sooooo`03
o`000?oooooooooo02Cooooo00?o0000ooooooooool0<?ooool003;ooooo00?o0000ooooooooool0
8oooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool0
8oooool2o`0002Cooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0Sooooo`03o`00
0?oooooooooo02Cooooo00?o0000ooooooooool0<?ooool003;ooooo0_l0000Tooooo`03o`000?oo
oooooooo02Cooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0Uooooo`03o`000?oo
oooooooo02;ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0Rooooo`03o`000?oo
oooooooo05Oooooo000booooo`;o00008oooool00ol0003oooooooooo`0Uooooo`03o`000?oooooo
oooo02;ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooo
oooo02Kooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`1Hooooo`00<_ooool2o`00
02?ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo
02Kooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo
023ooooo00?o0000ooooooooool0F?ooool003;ooooo00?o0000ooooool000008_ooool00ol0003o
ooooooooo`0Vooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool09_ooool00ol0003o
ooooooooo`0Pooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool08?ooool00ol0003o
ooooooooo`1Hooooo`00<_ooool00ol0003oooooo`00000Rooooo`03o`000?oooooooooo02Kooooo
00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo023ooooo
00?o0000ooooooooool09oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo05Wooooo
000booooo`03o`000?oooooo0000027ooooo00?o0000ooooooooool09oooool00ol0003ooooooooo
o`0Pooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool08?ooool00ol0003ooooooooo
o`0Wooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool0FOooool003;ooooo00?o0000
ooooool000008Oooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo01oooooo00?o0000
ooooooooool0:?ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo02Sooooo00?o0000
ooooooooool07oooool00ol0003oooooooooo`1Iooooo`00<_ooool01?l0003oooooooooool0000P
ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0Y
ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`0N
ooooo`03o`000?oooooooooo05Wooooo000booooo`04o`000?ooooooooooo`00023ooooo00?o0000
ooooooooool0:?ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo02Wooooo00?o0000
ooooooooool07_ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo01gooooo00?o0000
ooooooooool0F_ooool003;ooooo00Co0000oooooooooooo00007oooool00ol0003oooooooooo`0Z
ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`0N
ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`1J
ooooo`00<_ooool01?l0003oooooooooool0000Oooooo`03o`000?oooooooooo02[ooooo00?o0000
ooooooooool07?ooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo01gooooo00?o0000
ooooooooool0:Oooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo05[ooooo000boooo
o`05o`000?ooooooooooooooool000007_ooool00ol0003oooooooooo`0Zooooo`03o`000?oooooo
oooo01cooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`0Looooo`03o`000?oooooo
oooo02[ooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`1Jooooo`00<_ooool01Ol0
003ooooooooooooooooo000001gooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`0K
ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`0[
ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0F_ooool003;ooooo00Go0000oooo
ooooooooooooo`00000Mooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool06_ooool0
0ol0003oooooooooo`0/ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0:oooool0
0ol0003oooooooooo`0Kooooo`03o`000?oooooooooo05_ooooo000booooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0/ooooo`03o`000?oooooooooo
01[ooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo
02cooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`1Kooooo`00<_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0;Oooool00ol0003o
ooooooooo`0Jooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool06_ooool00ol0003o
ooooooooo`0]ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool0Foooool003;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo02kooooo
00?o0000ooooooooool06Oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo01[ooooo
00?o0000ooooooooool0;Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo05cooooo
000booooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool06Oooool00ol0003ooooooooo
o`0^ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0;_ooool00ol0003ooooooooo
o`0Iooooo`03o`000?oooooooooo02kooooo00?o0000ooooooooool06Oooool00ol0003ooooooooo
o`1Looooo`00<_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool0;oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo02oooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo01Wooooo00?o0000
ooooooooool0G?ooool003;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo033ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0_oooo
o`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`0Hoooo
o`03o`000?oooooooooo05cooooo000booooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool05oooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo01Oooooo00?o0000oooooooo
ool0;oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo033ooooo00?o0000oooooooo
ool05oooool00ol0003oooooooooo`1Mooooo`00<_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo01Oooooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0Fooooo`03o`00
0?oooooooooo033ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0`ooooo`03o`00
0?oooooooooo01Oooooo00?o0000ooooooooool0GOooool003;ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool05Ooo
ool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0<Ooo
ool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo05gooooo000booooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0booooo`03o`000?oooooo
oooo01Gooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooo
oooo037ooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`1Nooooo`00<_ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0<_ooool00ol0
003oooooooooo`0Dooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool05Oooool00ol0
003oooooooooo`0booooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0G_ooool003;o
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo03Co
oooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo01Co
oooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo05ko
oooo000booooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`0dooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0<oooool00ol0003ooooo
ooooo`0Dooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`1Oooooo`00<_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool0=?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo03Cooooo00?o
0000ooooooooool04oooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool0Goooool003;ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0e
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`0B
ooooo`03o`000?oooooooooo05oooooo000booooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0=Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo03Gooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`1Pooooo`00<_ooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`0@ooooo`03
o`000?oooooooooo03Kooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0gooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool0H?ooool003;ooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool0
3oooool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
=oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo063ooooo000booooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0hooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool0=oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo03Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`1Qooooo`00<_ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0>?ooool0
0ol0003oooooooooo`0>ooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool03_ooool0
0ol0003oooooooooo`0iooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0HOooool0
03;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
03[ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo
00kooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
06;ooooo000booooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`0jooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0>_ooool00ol0003o
ooooooooo`0<ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`1Rooooo`00<_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00gooooo
00?o0000ooooooooool0>oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo03_ooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo00gooooo
00?o0000ooooooooool0H_ooool003;ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0looooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0>oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo06?ooooo000booooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool0?Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo03gooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`1Sooooo`00<_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0?_ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo03kooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0noooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0I?ooool003;ooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo043ooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool0@?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo06Gooooo000Yooooo`?o0000
1_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
@Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
I_ooool002[ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0@oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo04?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`13ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0Ioooool002[ooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0=ooooo`;o00000oooool00ol0003oooooooooo`15ooooo`;o00000_ooool2
o`0004Oooooo0_l00002ooooo`;o0000Aoooool01?l0003oooooooooooooool2o`0006Wooooo000Z
ooooo`03o`000?oooooooooo00Gooooo0ol0000?ooooo`?o0000BOooool4o`0004Wooooo1?l00019
ooooo`?o0000Joooool002[ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`3ooooo
ofCooooo000Yooooo`;o00001oooool00ol0003oooooooooo`3oooooofCooooo000Zooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool0oooooomTooooo`00<_ooool00ol0003ooooooooo
o`3oooooofCooooo0000\
\>"],
  ImageRangeCache->{{{0, 407}, {67, 0}} -> {-2.05825, -0.340514, 0.0409371, \
0.0215006}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 7.13 M", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Transform", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[DoublePrime]",
                    MultilineFunction->None], "[", "t", "]"}], 
                "+", \(25\ y[t]\)}], "==", \(UnitStep[t - 1]\)}], 
            ",", \(y[0] == 0\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", "0"}]}], 
          "}"}], ",", "t", ",", "s"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          
          RowBox[{\(25\ LaplaceTransform[y[t], t, s]\), 
            "+", \(s\^2\ LaplaceTransform[y[t], t, s]\), "-", \(s\ y[0]\), 
            "-", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "0", "]"}]}], 
          "==", \(\[ExponentialE]\^\(-s\)\/s\)}], ",", \(y[0] == 0\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], "==", "0"}]}], 
      "}"}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Isolate[%, y[t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({LaplaceTransform[y[t], t, 
          s] \[Rule] \[ExponentialE]\^\(-s\)\/\(s\ \((25 + s\^2)\)\)}\)], \
"Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseLaplaceTransform[%, s, t]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({y[t] \[Rule] \((1\/25 - 
              1\/25\ Cos[5\ \((\(-1\) + t)\)])\)\ UnitStep[\(-1\) + 
              t]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(w[t_] = y[t] /. %\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\((1\/25 - 1\/25\ Cos[5\ \((\(-1\) + t)\)])\)\ UnitStep[\(-1\) + 
          t]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[w[t], {t, 0, 3}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.0147151 7.35759 [
[.18254 .00222 -9 -9 ]
[.18254 .00222 9 0 ]
[.34127 .00222 -3 -9 ]
[.34127 .00222 3 0 ]
[.5 .00222 -9 -9 ]
[.5 .00222 9 0 ]
[.65873 .00222 -3 -9 ]
[.65873 .00222 3 0 ]
[.81746 .00222 -9 -9 ]
[.81746 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .30902 -24 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .45617 -24 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -24 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .01472 m
.18254 .02097 L
s
[(0.5)] .18254 .00222 0 1 Mshowa
.34127 .01472 m
.34127 .02097 L
s
[(1)] .34127 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1.5)] .5 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(2)] .65873 .00222 0 1 Mshowa
.81746 .01472 m
.81746 .02097 L
s
[(2.5)] .81746 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(3)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .16187 m
.03006 .16187 L
s
[(0.02)] .01131 .16187 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(0.04)] .01131 .30902 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.06)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(0.08)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .0515 m
.02756 .0515 L
s
.02381 .08829 m
.02756 .08829 L
s
.02381 .12508 m
.02756 .12508 L
s
.02381 .19865 m
.02756 .19865 L
s
.02381 .23544 m
.02756 .23544 L
s
.02381 .27223 m
.02756 .27223 L
s
.02381 .34581 m
.02756 .34581 L
s
.02381 .38259 m
.02756 .38259 L
s
.02381 .41938 m
.02756 .41938 L
s
.02381 .49296 m
.02756 .49296 L
s
.02381 .52975 m
.02756 .52975 L
s
.02381 .56653 m
.02756 .56653 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .01472 L
.10458 .01472 L
.14415 .01472 L
.18221 .01472 L
.22272 .01472 L
.26171 .01472 L
.28158 .01472 L
.30316 .01472 L
.31323 .01472 L
.32392 .01472 L
.33304 .01472 L
.33554 .01472 L
.33823 .01472 L
.33953 .01472 L
.34076 .01472 L
.34187 .01473 L
.34309 .01484 L
.34373 .01494 L
.34441 .01508 L
.34564 .01541 L
.34695 .01589 L
.3484 .01657 L
.35099 .01815 L
.3534 .02007 L
.35792 .02477 L
.36276 .03141 L
.37373 .05234 L
.38373 .07811 L
.40282 .14249 L
.42358 .22925 L
.46436 .41485 L
.48461 .49563 L
.49453 .52877 L
.50362 .55446 L
.51247 .57464 L
.52179 .59032 L
.52664 .59609 L
.52895 .59827 L
.53114 .59997 L
.53239 .60078 L
.53374 .60153 L
.53486 .60206 L
.53609 .60253 L
.53743 .60292 L
.53816 .60308 L
.53884 .60319 L
.54006 .60331 L
.54137 .60331 L
.54206 .60326 L
Mistroke
.54271 .60318 L
.54392 .60295 L
.54522 .60259 L
.54663 .60205 L
.54917 .60073 L
.55151 .5991 L
.55688 .59386 L
.56255 .58612 L
.57214 .56805 L
.58265 .54149 L
.6022 .47586 L
.62313 .3884 L
.66454 .20009 L
.68528 .11813 L
.69439 .08805 L
.70444 .06018 L
.71405 .03933 L
.71844 .03183 L
.72306 .02537 L
.72544 .02264 L
.72803 .02011 L
.73041 .01821 L
.73258 .01684 L
.73381 .01621 L
.73515 .01565 L
.73588 .0154 L
.73656 .0152 L
.73724 .01503 L
.73789 .01491 L
.73903 .01477 L
.74028 .01472 L
.74151 .01478 L
.74282 .01497 L
.74403 .01525 L
.74538 .01569 L
.74678 .01629 L
.74809 .01699 L
.75044 .01854 L
.75298 .02065 L
.75874 .02718 L
.76404 .03521 L
.77383 .05504 L
.78415 .08244 L
.80387 .15068 L
.82223 .22799 L
.86124 .40592 L
.88113 .48684 L
.8916 .52294 L
.9027 .55484 L
.91259 .57697 L
Mistroke
.91822 .58668 L
.92348 .59381 L
.92596 .59648 L
.92831 .59862 L
.93044 .60022 L
.93272 .60156 L
.93401 .60216 L
.93518 .60259 L
.93636 .60292 L
.93747 .60315 L
.93877 .60329 L
.93996 .60332 L
.94127 .60323 L
.94193 .60314 L
.94265 .603 L
.94374 .60272 L
.94474 .60238 L
.947 .60136 L
.949 .60015 L
.95112 .59854 L
.95479 .59501 L
.95884 .59 L
.96779 .57492 L
.97619 .55596 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00?Oooool2o`0000Cooooo00?o0000ooooooooool0
0_ooool3o`00023ooooo0ol0000Pooooo`?o00001?ooool00ol0003oooooooooo`02ooooo`?o0000
8?ooool5o`0001kooooo1Ol00003ooooo`03o`000?oooooooooo00;ooooo0ol0000Pooooo`?o0000
1_ooool003cooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo0000023o
oooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`07ooooo`05o`000?oooooooooooooo
ool000008?ooool01?l0003oooooooooool0000Oooooo`04o`000?ooooooooooo`0000Oooooo00Go
0000ooooooooooooooooo`00000Nooooo`05o`000?ooooooooooooooool000001Oooool003cooooo
00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo023o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo023o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00?o
oooo000looooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool07_ooool00ol0003o
ooooooooo`0Pooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool08?ooool00ol0003o
ooooooooo`0Pooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool07_ooool2o`0000Ko
oooo000looooo`04o`000?ooooooooooo`0000Oooooo1?l0000Qooooo`03o`000?oooooooooo023o
oooo00?o0000ooooooooool01oooool4o`00023ooooo00Go0000ooooooooooooooooo`00000Noooo
o`05o`000?ooooooooooooooool000001oooool4o`0002?ooooo00?o0000ooooooooool00oooool0
03cooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0Qooooo`;o00008Oooool2
o`0000Wooooo00?o0000ooooooooool08Oooool01Ol0003ooooooooooooooooo000001kooooo00Go
0000ooooooooooooooooo`000007ooooo`03o`000?oooooooooo023ooooo00Go0000oooooooooooo
ooooo`000005ooooo`00?Oooool2o`0000Sooooo1Ol0000Pooooo`03o`000?oooooooooo023ooooo
00?o0000ooooooooool01oooool5o`00023ooooo0ol0000Pooooo`?o00002?ooool5o`0001oooooo
0ol00006ooooo`00oooooolJooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0
003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`005Oooooooo`0000Go0000
000Kooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Gooooo1?l00004ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool01Oooool00ol0003oooooo`000002o`000004ooooool0003o0000o`0000Sooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool001_ooooo00?o0000ooooooooool09_ooool00ol0003ooooooooo
o`0Vooooo`03o`000?oooooooooo00;o00009?ooool00ol0003oooooooooo`0Wooooo`03o`000?oo
oooooooo00kooooo0_l00005ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool09_oo
ool00ol0003oooooooooo`04ooooo`006oooool00ol0003oooooooooo`1Dooooo`03o`000?oooooo
oooo05_ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0mooooo`006oooool00ol0
003oooooooooo`1Dooooo`03o`000?oooooooooo05_ooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`0looooo`006oooool00ol0003oooooooooo`1Eooooo`03o`000?oooooooooo05Wo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0looooo`006oooool00ol0003ooooo
ooooo`1Eooooo`03o`000?oooooooooo05Wooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`0kooooo`006oooool00ol0003oooooooooo`1Fooooo`03o`000?oooooooooo05Oooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0kooooo`006oooool00ol0003oooooooooo`1G
ooooo`03o`000?oooooooooo05Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0j
ooooo`006oooool00ol0003oooooooooo`1Gooooo`03o`000?oooooooooo05Gooooo00?o0000oooo
ooooool03Oooool00ol0003oooooooooo`0iooooo`006oooool2o`0005Wooooo00?o0000oooooooo
ool0E?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo03Wooooo000Kooooo`03o`00
0?oooooooooo05Sooooo00?o0000ooooooooool0E?ooool00ol0003oooooooooo`0>ooooo`03o`00
0?oooooooooo03Sooooo000Kooooo`03o`000?oooooooooo05Sooooo00?o0000ooooooooool0Dooo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo03Sooooo000Kooooo`03o`000?oooooo
oooo05Wooooo00?o0000ooooooooool0D_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo03Sooooo000Kooooo`03o`000?oooooooooo05Wooooo00?o0000ooooooooool0DOooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo03Oooooo000Kooooo`03o`000?oooooooooo05Wo
oooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo03Oo
oooo000Kooooo`03o`000?oooooooooo05[ooooo00?o0000ooooooooool0Coooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo03Oooooo000Kooooo`03o`000?oooooooooo05[ooooo00?o
0000ooooooooool0Coooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo03Kooooo000K
ooooo`03o`000?oooooooooo05[ooooo00?o0000ooooooooool0Coooool00ol0003oooooooooo`0C
ooooo`03o`000?oooooooooo03Kooooo000Kooooo`;o0000Foooool00ol0003oooooooooo`1>oooo
o`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0=_ooool001_ooooo00?o0000oooooooo
ool0Foooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo01Cooooo00?o0000oooooooo
ool0=_ooool001_ooooo00?o0000ooooooooool0Foooool00ol0003oooooooooo`1=ooooo`03o`00
0?oooooooooo01Gooooo00?o0000ooooooooool0=Oooool001_ooooo00?o0000ooooooooool0Fooo
ool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0=Ooo
ool001_ooooo00?o0000ooooooooool0G?ooool00ol0003oooooooooo`1;ooooo`03o`000?oooooo
oooo01Kooooo00?o0000ooooooooool0=Oooool001_ooooo00?o0000ooooooooool0G?ooool00ol0
003oooooooooo`1;ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0=?ooool001_o
oooo00?o0000ooooooooool0G?ooool00ol0003oooooooooo`1;ooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool0=?ooool001_ooooo00?o0000ooooooooool0GOooool00ol0003ooooo
ooooo`19ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0=?ooool001_ooooo00?o
0000ooooooooool0GOooool00ol0003oooooooooo`19ooooo`03o`000?oooooooooo01Sooooo00?o
0000ooooooooool0=?ooool001_ooooo00?o0000ooooooooool0GOooool00ol0003oooooooooo`19
ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0<oooool001_ooooo0_l0001Noooo
o`03o`000?oooooooooo04Wooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0coooo
o`006oooool00ol0003oooooooooo`1Nooooo`03o`000?oooooooooo04Oooooo00?o0000oooooooo
ool06_ooool00ol0003oooooooooo`0cooooo`006oooool00ol0003oooooooooo`1Nooooo`03o`00
0?oooooooooo04Oooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0cooooo`006ooo
ool00ol0003oooooooooo`1Nooooo`03o`000?oooooooooo04Oooooo00?o0000ooooooooool06ooo
ool00ol0003oooooooooo`0booooo`006oooool00ol0003oooooooooo`1Oooooo`03o`000?oooooo
oooo04Gooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`0booooo`006oooool00ol0
003oooooooooo`1Oooooo`03o`000?oooooooooo04Gooooo00?o0000ooooooooool07?ooool00ol0
003oooooooooo`0booooo`006oooool00ol0003oooooooooo`1Oooooo`03o`000?oooooooooo04Go
oooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0aooooo`000_ooool2o`0000Cooooo
00?o0000ooooooooool00oooool2o`0000;ooooo1Ol00004ooooo`03o`000?oooooooooo05oooooo
00?o0000ooooooooool0AOooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo037ooooo
00001Ooooooo0000oooooooooooo000000Sooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00004ooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool0@oooool00ol0
003oooooooooo`0Nooooo`03o`000?oooooooooo037ooooo00001Ooooooo0000oooooooooooo0000
00Sooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo063ooooo00?o0000ooooooooool0@oooool00ol0003oooooooooo`0Nooooo`03o`000?oooooo
oooo037ooooo00001Ooooooo0000oooooooooooo000000Sooooo00Co0000oooooooooooo00001?oo
ool00ol0003oooooooooo`03ooooo`;o0000HOooool00ol0003oooooooooo`13ooooo`03o`000?oo
oooooooo01oooooo00?o0000ooooooooool0<?ooool00005ooooool0003oooooooooool000002?oo
ool01_l0003oooooooooool0003oooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`1Qooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool08?ooool00ol0003o
ooooooooo`0`ooooo`0000Goooooo`000?ooooooooooo`000008ooooo`06o`000?ooooooooooo`00
0?oooooo00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo067ooooo00?o0000
ooooooooool0@Oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo033ooooo0002oooo
o`;o00002_ooool2o`0000?ooooo0ol00005ooooo`03o`000?oooooooooo067ooooo00?o0000oooo
ooooool0@Oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo033ooooo000Kooooo`03
o`000?oooooooooo067ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`0Qooooo`03
o`000?oooooooooo02oooooo000Kooooo`03o`000?oooooooooo06;ooooo00?o0000ooooooooool0
?oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo02oooooo000Kooooo`03o`000?oo
oooooooo06;ooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`0Rooooo`03o`000?oo
oooooooo02oooooo000Kooooo`03o`000?oooooooooo06;ooooo00?o0000ooooooooool0?oooool0
0ol0003oooooooooo`0Rooooo`03o`000?oooooooooo02oooooo000Kooooo`03o`000?oooooooooo
06;ooooo00?o0000ooooooooool0?_ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo
02kooooo000Kooooo`;o0000I?ooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo02Co
oooo00?o0000ooooooooool0;_ooool001_ooooo00?o0000ooooooooool0Hoooool00ol0003ooooo
ooooo`0mooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0;_ooool001_ooooo00?o
0000ooooooooool0Hoooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo02Cooooo00?o
0000ooooooooool0;_ooool001_ooooo00?o0000ooooooooool0I?ooool00ol0003oooooooooo`0k
ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0;Oooool001_ooooo00?o0000oooo
ooooool0I?ooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo02Kooooo00?o0000oooo
ooooool0;Oooool001_ooooo00?o0000ooooooooool0I?ooool00ol0003oooooooooo`0kooooo`03
o`000?oooooooooo02Kooooo00?o0000ooooooooool0;Oooool001_ooooo00?o0000ooooooooool0
I?ooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0
;Oooool001_ooooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`0jooooo`03o`000?oo
oooooooo02Oooooo00?o0000ooooooooool0;?ooool001_ooooo00?o0000ooooooooool0IOooool0
0ol0003oooooooooo`0iooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool0;?ooool0
01_ooooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo
02Sooooo00?o0000ooooooooool0;?ooool001_ooooo0_l0001Vooooo`03o`000?oooooooooo03Wo
oooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0/ooooo`006oooool00ol0003ooooo
ooooo`1Vooooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool0:Oooool00ol0003ooooo
ooooo`0[ooooo`006oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo03Oooooo00?o
0000ooooooooool0:_ooool00ol0003oooooooooo`0[ooooo`006oooool00ol0003oooooooooo`1V
ooooo`03o`000?oooooooooo03Oooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0[
ooooo`006oooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo03Oooooo00?o0000oooo
ooooool0:_ooool00ol0003oooooooooo`0[ooooo`006oooool00ol0003oooooooooo`1Vooooo`03
o`000?oooooooooo03Oooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0[ooooo`00
6oooool00ol0003oooooooooo`1Wooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool0
:oooool00ol0003oooooooooo`0Zooooo`006oooool00ol0003oooooooooo`1Wooooo`03o`000?oo
oooooooo03Gooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`0Zooooo`006oooool0
0ol0003oooooooooo`1Wooooo`03o`000?oooooooooo03Gooooo00?o0000ooooooooool0;?ooool0
0ol0003oooooooooo`0Zooooo`006oooool2o`0006Sooooo00?o0000ooooooooool0=Oooool00ol0
003oooooooooo`0/ooooo`03o`000?oooooooooo02[ooooo000Kooooo`03o`000?oooooooooo06Oo
oooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo02Wo
oooo000Kooooo`03o`000?oooooooooo06Sooooo00?o0000ooooooooool0<oooool00ol0003ooooo
ooooo`0^ooooo`03o`000?oooooooooo02Wooooo000Kooooo`03o`000?oooooooooo06Sooooo00?o
0000ooooooooool0<oooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo02Wooooo000K
ooooo`03o`000?oooooooooo06Sooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`0^
ooooo`03o`000?oooooooooo02Wooooo000Kooooo`03o`000?oooooooooo06Sooooo00?o0000oooo
ooooool0<oooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo02Wooooo000Kooooo`03
o`000?oooooooooo06Sooooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`0`ooooo`03
o`000?oooooooooo02Sooooo0002ooooo`;o00001?ooool00ol0003oooooooooo`03ooooo`;o0000
1?ooool3o`0000Cooooo00?o0000ooooooooool0JOooool00ol0003oooooooooo`0aooooo`03o`00
0?oooooooooo033ooooo00?o0000ooooooooool0:?ooool00005ooooool0003oooooooooool00000
2?ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool0JOooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo033ooooo00?o0000oooooooo
ool0:?ooool00005ooooool0003oooooooooool000002?ooool01Ol0003oooooooooool0003ooooo
00Go00001?ooool00ol0003oooooooooo`1Yooooo`03o`000?oooooooooo037ooooo00?o0000oooo
ooooool0<?ooool00ol0003oooooooooo`0Xooooo`0000Goooooo`000?ooooooooooo`000008oooo
o`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`03ooooo`;o0000J_oo
ool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool0:?oo
ool00005ooooool0003oooooooooool000002?ooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooo000000Gooooo00?o0000ooooooooool0JOooool00ol0003oooooooooo`0`ooooo`03o`00
0?oooooooooo03;ooooo00?o0000ooooooooool09oooool00005ooooool0003oooooooooool00000
2?ooool01?l0003oooooooooool00003ooooo`;o00001Oooool00ol0003oooooooooo`1Zooooo`03
o`000?oooooooooo02oooooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`0Wooooo`00
0_ooool2o`0000[ooooo0_l00005ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
J_ooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool0
9oooool001_ooooo00?o0000ooooooooool0J_ooool00ol0003oooooooooo`0_ooooo`03o`000?oo
oooooooo03;ooooo00?o0000ooooooooool09oooool001_ooooo00?o0000ooooooooool0J_ooool0
0ol0003oooooooooo`0^ooooo`03o`000?oooooooooo03Cooooo00?o0000ooooooooool09_ooool0
01_ooooo00?o0000ooooooooool0Joooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo
03Cooooo00?o0000ooooooooool09_ooool001_ooooo00?o0000ooooooooool0Joooool00ol0003o
ooooooooo`0]ooooo`03o`000?oooooooooo03Cooooo00?o0000ooooooooool09_ooool001_ooooo
00?o0000ooooooooool0Joooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo03Cooooo
00?o0000ooooooooool09_ooool001_ooooo0_l0001/ooooo`03o`000?oooooooooo02gooooo00?o
0000ooooooooool0=?ooool00ol0003oooooooooo`0Vooooo`006oooool00ol0003oooooooooo`1[
ooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`0U
ooooo`006oooool00ol0003oooooooooo`1/ooooo`03o`000?oooooooooo02_ooooo00?o0000oooo
ooooool0=_ooool00ol0003oooooooooo`0Uooooo`006oooool00ol0003oooooooooo`1/ooooo`03
o`000?oooooooooo02_ooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`0Uooooo`00
6oooool00ol0003oooooooooo`1/ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool0
=_ooool00ol0003oooooooooo`0Uooooo`006oooool00ol0003oooooooooo`1/ooooo`03o`000?oo
oooooooo02[ooooo00?o0000ooooooooool0>?ooool00ol0003oooooooooo`0Tooooo`006oooool0
0ol0003oooooooooo`1/ooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool0>?ooool0
0ol0003oooooooooo`0Tooooo`006oooool00ol0003oooooooooo`1]ooooo`03o`000?oooooooooo
02Wooooo00?o0000ooooooooool0>?ooool00ol0003oooooooooo`0Tooooo`006oooool00ol0003o
ooooooooo`1]ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0>?ooool00ol0003o
ooooooooo`0Tooooo`006oooool00ol0003oooooooooo`1]ooooo`03o`000?oooooooooo02Wooooo
00?o0000ooooooooool0>?ooool00ol0003oooooooooo`0Tooooo`006oooool2o`0006kooooo00?o
0000ooooooooool0:?ooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo02?ooooo000K
ooooo`03o`000?oooooooooo06gooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0j
ooooo`03o`000?oooooooooo02?ooooo000Kooooo`03o`000?oooooooooo06kooooo00?o0000oooo
ooooool09oooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo02?ooooo000Kooooo`03
o`000?oooooooooo06kooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0jooooo`03
o`000?oooooooooo02?ooooo000Kooooo`03o`000?oooooooooo06kooooo00?o0000ooooooooool0
9_ooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo02?ooooo000Kooooo`03o`000?oo
oooooooo06kooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`0looooo`03o`000?oo
oooooooo02;ooooo000Kooooo`03o`000?oooooooooo06kooooo00?o0000ooooooooool09_ooool0
0ol0003oooooooooo`0looooo`03o`000?oooooooooo02;ooooo000Kooooo`03o`000?oooooooooo
06oooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo
02;ooooo000Kooooo`03o`000?oooooooooo06oooooo00?o0000ooooooooool09Oooool00ol0003o
ooooooooo`0looooo`03o`000?oooooooooo02;ooooo000Kooooo`;o0000L?ooool00ol0003ooooo
ooooo`0Tooooo`03o`000?oooooooooo03kooooo00?o0000ooooooooool08Oooool001_ooooo00?o
0000ooooooooool0Koooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo03kooooo00?o
0000ooooooooool08Oooool001_ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0S
ooooo`03o`000?oooooooooo03kooooo00?o0000ooooooooool08Oooool001_ooooo00?o0000oooo
ooooool0L?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo03kooooo00?o0000oooo
ooooool08Oooool001_ooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0Rooooo`03
o`000?oooooooooo043ooooo00?o0000ooooooooool08?ooool001_ooooo00?o0000ooooooooool0
L?ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo043ooooo00?o0000ooooooooool0
8?ooool001_ooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0Qooooo`03o`000?oo
oooooooo043ooooo00?o0000ooooooooool08?ooool000;ooooo0_l00004ooooo`03o`000?oooooo
oooo00?ooooo0_l00003ooooo`?o00001Oooool00ol0003oooooooooo`1aooooo`03o`000?oooooo
oooo027ooooo00?o0000ooooooooool0@?ooool00ol0003oooooooooo`0Pooooo`0000Goooooo`00
0?ooooooooooo`000008ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool08Oooool00ol0003ooooo
ooooo`11ooooo`03o`000?oooooooooo01oooooo00001Ooooooo0000oooooooooooo000000Sooooo
00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0LOooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo04;ooooo00?o0000oooo
ooooool07oooool00005ooooool0003oooooooooool000002?ooool01Ol0003oooooooooool0003o
oooo00Co00001Oooool2o`0007?ooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`12
ooooo`03o`000?oooooooooo01oooooo00001Ooooooo0000oooooooooooo000000Sooooo00Ko0000
oooooooooooo0000ooooool00008ooooo`03o`000?oooooooooo07;ooooo00?o0000ooooooooool0
7oooool00ol0003oooooooooo`12ooooo`03o`000?oooooooooo01oooooo00001Ooooooo0000oooo
oooooooo000000Sooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo07;ooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`12ooooo`03
o`000?oooooooooo01oooooo0002ooooo`;o00002_ooool2o`0000Cooooo0_l00005ooooo`03o`00
0?oooooooooo07;ooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`13ooooo`03o`00
0?oooooooooo01kooooo000Kooooo`03o`000?oooooooooo07;ooooo00?o0000ooooooooool07_oo
ool00ol0003oooooooooo`14ooooo`03o`000?oooooooooo01kooooo000Kooooo`03o`000?oooooo
oooo07?ooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`14ooooo`03o`000?oooooo
oooo01kooooo000Kooooo`03o`000?oooooooooo07?ooooo00?o0000ooooooooool07Oooool00ol0
003oooooooooo`14ooooo`03o`000?oooooooooo01kooooo000Kooooo`03o`000?oooooooooo07?o
oooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`15ooooo`03o`000?oooooooooo01go
oooo000Kooooo`03o`000?oooooooooo07?ooooo00?o0000ooooooooool07?ooool00ol0003ooooo
ooooo`16ooooo`03o`000?oooooooooo01gooooo000Kooooo`03o`000?oooooooooo07Cooooo00?o
0000ooooooooool06oooool00ol0003oooooooooo`16ooooo`03o`000?oooooooooo01gooooo000K
ooooo`;o0000MOooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo04Oooooo00?o0000
ooooooooool07?ooool001_ooooo00?o0000ooooooooool0M?ooool00ol0003oooooooooo`0Joooo
o`03o`000?oooooooooo04Sooooo00?o0000ooooooooool07?ooool001_ooooo00?o0000oooooooo
ool0MOooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo04Sooooo00?o0000oooooooo
ool07?ooool001_ooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`0Iooooo`03o`00
0?oooooooooo04Wooooo00?o0000ooooooooool06oooool001_ooooo00?o0000ooooooooool0MOoo
ool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo04[ooooo00?o0000ooooooooool06ooo
ool001_ooooo00?o0000ooooooooool0M_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooo
oooo04[ooooo00?o0000ooooooooool06oooool001_ooooo00?o0000ooooooooool0M_ooool00ol0
003oooooooooo`0Gooooo`03o`000?oooooooooo04_ooooo00?o0000ooooooooool06_ooool001_o
oooo00?o0000ooooooooool0M_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo04_o
oooo00?o0000ooooooooool06_ooool001_ooooo00?o0000ooooooooool0Moooool00ol0003ooooo
ooooo`0Eooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool06_ooool001_ooooo0_l0
001hooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0COooool00ol0003ooooooooo
o`0Iooooo`006oooool00ol0003oooooooooo`1gooooo`03o`000?oooooooooo01Gooooo00?o0000
ooooooooool0COooool00ol0003oooooooooo`0Iooooo`006oooool00ol0003oooooooooo`1goooo
o`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0C_ooool00ol0003oooooooooo`0Ioooo
o`006oooool00ol0003oooooooooo`1hooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool0Coooool00ol0003oooooooooo`0Hooooo`006oooool00ol0003oooooooooo`1hooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool0Coooool00ol0003oooooooooo`0Hooooo`006ooo
ool00ol0003oooooooooo`1hooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0D?oo
ool00ol0003oooooooooo`0Hooooo`006oooool00ol0003oooooooooo`1iooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Gooooo`006oooool00ol0
003oooooooooo`1iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0D_ooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo00Cooooo000Kooooo`03o`000?oooooooooo07Wo
oooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool01?ooool001_ooooo00?o0000ooooooooool0N_ooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo05?ooooo00?o0000ooooooooool03_ooool00ol0003ooooo
ooooo`05ooooo`006oooool2o`0007cooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`1Eooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01Oooool001_ooooo00?o0000
ooooooooool0Noooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo05Gooooo00?o0000
ooooooooool03Oooool00ol0003oooooooooo`05ooooo`006oooool00ol0003oooooooooo`1loooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0Eoooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00Kooooo000Kooooo`03o`000?oooooooooo07cooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`1Gooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool01_ooool001_ooooo00?o0000ooooooooool0OOooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo05Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`07ooooo`006ooo
ool00ol0003oooooooooo`1mooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0FOoo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oooooo000Kooooo`03o`000?oooooo
oooo07kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`1Jooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool000;ooooo0_l00004ooooo`03o`000?oooooooooo
00?ooooo0_l00003ooooo`?o00001Oooool00ol0003oooooooooo`1oooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool0G?ooool2o`0000Oooooo00?o0000ooooooooool02Oooool00005
ooooool0003oooooooooool000002?ooool01_l0003oooooooooool0003oooooo`0000?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`20ooooo`;o00001?ooool00ol0003ooooooooo
o`1Oooooo`03o`000?oooooooooo00;ooooo0_l0000<ooooo`0000Goooooo`000?ooooooooooo`00
0008ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooooooo`02ooooo`;o
0000P_ooool5o`0006?ooooo1Ol0000=ooooo`0000Goooooo`000?ooooooooooo`000008ooooo`04
o`000?ooooooooooo`0000;ooooo0ol00005ooooo`03o`000?oooooooooo0?_ooooo00001Ooooooo
0000oooooooooooo000000Sooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0noooool00005ooooool0003oooooooooool000002?oo
ool01_l0003oooooooooool0003oooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`3kooooo`000_ooool2o`0000[ooooo0_l00003ooooo`?o00001Oooool00ol0003ooooo
ooooo`3kooooo`00oooooolJooooo`00oooooolJooooo`00\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-0.330441, -0.00733715, \
0.0121272, 0.000523254}}]
}, Closed]],

Cell[BoxData[
    \(L[t_, y_] := \[PartialD]\_{t, 2}y[t] + 25\ y[t] - 
        UnitStep[t - 1]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[t, w]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 7.14 M", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f[t_] := 
      t\^2\ UnitPulse[t, 0, 1] + 
        1\/2\ \((t - 3\/2)\)\^2\ UnitPulse[t, 1, 
            2] + \((6 - t\^2)\)\ UnitStep[t - 2]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Transform", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[DoublePrime]",
                    MultilineFunction->None], "[", "t", "]"}], "+", 
                RowBox[{"5", " ", 
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], 
                "+", \(6\ y[t]\)}], "==", \(f[t]\)}], ",", \(y[0] == 0\), ",",
             
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", \(-2\)}]}],
           "}"}], ",", "t", ",", "s"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          
          RowBox[{\(6\ LaplaceTransform[y[t], t, s]\), 
            "+", \(s\^2\ LaplaceTransform[y[t], t, s]\), 
            "+", \(5\ \((s\ LaplaceTransform[y[t], t, s] - y[0])\)\), 
            "-", \(s\ y[0]\), "-", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "0", "]"}]}], 
          "==", \(2\/s\^3 + \(39\ \[ExponentialE]\^\(\(-2\)\ s\)\)\/\(8\ s\) \
+ \(9\ \[ExponentialE]\^\(-s\)\)\/\(8\ s\) - \(3\ \[ExponentialE]\^\(-s\)\ \
\((1 + s)\)\)\/\(2\ s\^2\) + \(3\ \[ExponentialE]\^\(\(-2\)\ s\)\ \((1 + 2\ \
s)\)\)\/\(2\ s\^2\) - \(\[ExponentialE]\^\(-s\)\ \((2 + 2\ s + s\^2)\)\)\/\(2\
\ s\^3\) - \(3\ \[ExponentialE]\^\(\(-2\)\ s\)\ \((2 + 4\ s + 4\ \
s\^2)\)\)\/\(2\ s\^3\)\)}], ",", \(y[0] == 0\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], "==", \(-2\)}]}], 
      "}"}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Isolate[%, y[t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({LaplaceTransform[y[t], t, 
          s] \[Rule] \(-\(\((\[ExponentialE]\^\(\(-2\)\ s\)\ \((24 + 
                    8\ \[ExponentialE]\^s - 16\ \[ExponentialE]\^\(2\ s\) + 
                    36\ s + 20\ \[ExponentialE]\^s\ s - 15\ s\^2 + 
                    7\ \[ExponentialE]\^s\ s\^2 + 
                    16\ \[ExponentialE]\^\(2\ s\)\ s\^3)\))\)/\((8\ s\^3\ \
\((6 + 5\ s + s\^2)\))\)\)\)}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseLaplaceTransform[%, s, t] // Simplify\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({y[t] \[Rule] 
        1\/432\ \[ExponentialE]\^\(\(-3\)\ t\)\ \((896 - 
              972\ \[ExponentialE]\^t + 76\ \[ExponentialE]\^\(3\ t\) - 
              120\ \[ExponentialE]\^\(3\ t\)\ t + 
              72\ \[ExponentialE]\^\(3\ t\)\ t\^2 - 
              3\ \((\(-146\)\ \[ExponentialE]\^6 + 
                    243\ \[ExponentialE]\^\(4 + t\) + \[ExponentialE]\^\(3\ t\
\)\ \((\(-49\) - 96\ t + 36\ t\^2)\))\)\ UnitStep[\(-2\) + 
                    t] - \((22\ \[ExponentialE]\^3 + 
                    27\ \[ExponentialE]\^\(2 + t\) + \[ExponentialE]\^\(3\ \
t\)\ \((\(-133\) + 48\ t + 36\ t\^2)\))\)\ UnitStep[\(-1\) + 
                    t])\)}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(w[t_] = y[t] /. %;\)\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[w[t], {t, 0, 3}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.496155 1.63305 [
[.18254 .48365 -9 -9 ]
[.18254 .48365 9 0 ]
[.34127 .48365 -3 -9 ]
[.34127 .48365 3 0 ]
[.5 .48365 -9 -9 ]
[.5 .48365 9 0 ]
[.65873 .48365 -3 -9 ]
[.65873 .48365 3 0 ]
[.81746 .48365 -9 -9 ]
[.81746 .48365 9 0 ]
[.97619 .48365 -3 -9 ]
[.97619 .48365 3 0 ]
[.01131 .00624 -24 -4.5 ]
[.01131 .00624 0 4.5 ]
[.01131 .08789 -30 -4.5 ]
[.01131 .08789 0 4.5 ]
[.01131 .16955 -24 -4.5 ]
[.01131 .16955 0 4.5 ]
[.01131 .2512 -30 -4.5 ]
[.01131 .2512 0 4.5 ]
[.01131 .33285 -24 -4.5 ]
[.01131 .33285 0 4.5 ]
[.01131 .4145 -30 -4.5 ]
[.01131 .4145 0 4.5 ]
[.01131 .57781 -24 -4.5 ]
[.01131 .57781 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .49615 m
.18254 .5024 L
s
[(0.5)] .18254 .48365 0 1 Mshowa
.34127 .49615 m
.34127 .5024 L
s
[(1)] .34127 .48365 0 1 Mshowa
.5 .49615 m
.5 .5024 L
s
[(1.5)] .5 .48365 0 1 Mshowa
.65873 .49615 m
.65873 .5024 L
s
[(2)] .65873 .48365 0 1 Mshowa
.81746 .49615 m
.81746 .5024 L
s
[(2.5)] .81746 .48365 0 1 Mshowa
.97619 .49615 m
.97619 .5024 L
s
[(3)] .97619 .48365 0 1 Mshowa
.125 Mabswid
.05556 .49615 m
.05556 .4999 L
s
.0873 .49615 m
.0873 .4999 L
s
.11905 .49615 m
.11905 .4999 L
s
.15079 .49615 m
.15079 .4999 L
s
.21429 .49615 m
.21429 .4999 L
s
.24603 .49615 m
.24603 .4999 L
s
.27778 .49615 m
.27778 .4999 L
s
.30952 .49615 m
.30952 .4999 L
s
.37302 .49615 m
.37302 .4999 L
s
.40476 .49615 m
.40476 .4999 L
s
.43651 .49615 m
.43651 .4999 L
s
.46825 .49615 m
.46825 .4999 L
s
.53175 .49615 m
.53175 .4999 L
s
.56349 .49615 m
.56349 .4999 L
s
.59524 .49615 m
.59524 .4999 L
s
.62698 .49615 m
.62698 .4999 L
s
.69048 .49615 m
.69048 .4999 L
s
.72222 .49615 m
.72222 .4999 L
s
.75397 .49615 m
.75397 .4999 L
s
.78571 .49615 m
.78571 .4999 L
s
.84921 .49615 m
.84921 .4999 L
s
.88095 .49615 m
.88095 .4999 L
s
.9127 .49615 m
.9127 .4999 L
s
.94444 .49615 m
.94444 .4999 L
s
.25 Mabswid
0 .49615 m
1 .49615 L
s
.02381 .00624 m
.03006 .00624 L
s
[(-0.3)] .01131 .00624 1 0 Mshowa
.02381 .08789 m
.03006 .08789 L
s
[(-0.25)] .01131 .08789 1 0 Mshowa
.02381 .16955 m
.03006 .16955 L
s
[(-0.2)] .01131 .16955 1 0 Mshowa
.02381 .2512 m
.03006 .2512 L
s
[(-0.15)] .01131 .2512 1 0 Mshowa
.02381 .33285 m
.03006 .33285 L
s
[(-0.1)] .01131 .33285 1 0 Mshowa
.02381 .4145 m
.03006 .4145 L
s
[(-0.05)] .01131 .4145 1 0 Mshowa
.02381 .57781 m
.03006 .57781 L
s
[(0.05)] .01131 .57781 1 0 Mshowa
.125 Mabswid
.02381 .02257 m
.02756 .02257 L
s
.02381 .0389 m
.02756 .0389 L
s
.02381 .05523 m
.02756 .05523 L
s
.02381 .07156 m
.02756 .07156 L
s
.02381 .10422 m
.02756 .10422 L
s
.02381 .12055 m
.02756 .12055 L
s
.02381 .13688 m
.02756 .13688 L
s
.02381 .15322 m
.02756 .15322 L
s
.02381 .18588 m
.02756 .18588 L
s
.02381 .20221 m
.02756 .20221 L
s
.02381 .21854 m
.02756 .21854 L
s
.02381 .23487 m
.02756 .23487 L
s
.02381 .26753 m
.02756 .26753 L
s
.02381 .28386 m
.02756 .28386 L
s
.02381 .30019 m
.02756 .30019 L
s
.02381 .31652 m
.02756 .31652 L
s
.02381 .34918 m
.02756 .34918 L
s
.02381 .36551 m
.02756 .36551 L
s
.02381 .38184 m
.02756 .38184 L
s
.02381 .39817 m
.02756 .39817 L
s
.02381 .43083 m
.02756 .43083 L
s
.02381 .44716 m
.02756 .44716 L
s
.02381 .46349 m
.02756 .46349 L
s
.02381 .47982 m
.02756 .47982 L
s
.02381 .51249 m
.02756 .51249 L
s
.02381 .52882 m
.02756 .52882 L
s
.02381 .54515 m
.02756 .54515 L
s
.02381 .56148 m
.02756 .56148 L
s
.02381 .59414 m
.02756 .59414 L
s
.02381 .61047 m
.02756 .61047 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .49615 m
.04262 .32927 L
.06244 .20278 L
.07286 .15295 L
.08255 .11521 L
.0932 .08224 L
.10458 .05552 L
.1148 .03805 L
.12056 .03061 L
.12589 .02513 L
.13054 .02138 L
.13566 .01827 L
.13824 .01709 L
.14101 .0161 L
.14235 .01572 L
.14363 .01541 L
.14488 .01517 L
.14603 .01499 L
.14727 .01485 L
.14792 .0148 L
.14861 .01475 L
.14978 .01472 L
.15105 .01472 L
.15219 .01477 L
.15341 .01487 L
.15456 .015 L
.15561 .01515 L
.15813 .01565 L
.16086 .01639 L
.16583 .01824 L
.17046 .02052 L
.17538 .02349 L
.18422 .03009 L
.20369 .04955 L
.22197 .07261 L
.26066 .13141 L
.3018 .20213 L
.34142 .27364 L
.37953 .33404 L
.42009 .38133 L
.45913 .41409 L
.47905 .42702 L
.50063 .4387 L
.54061 .4553 L
.58153 .46744 L
.62094 .47631 L
.64073 .48019 L
.64939 .48183 L
.65882 .48358 L
.66133 .48414 L
Mistroke
.664 .48494 L
.6688 .48684 L
.67827 .49214 L
.68924 .5003 L
.69916 .50904 L
.73928 .54933 L
.7577 .56679 L
.77789 .58298 L
.78753 .58927 L
.79786 .59482 L
.80357 .59733 L
.80877 .59924 L
.81371 .60073 L
.81641 .6014 L
.81894 .60195 L
.82141 .60239 L
.82367 .60272 L
.82618 .603 L
.8275 .60312 L
.82888 .60321 L
.82998 .60326 L
.83116 .6033 L
.83226 .60332 L
.83327 .60332 L
.83445 .6033 L
.83574 .60326 L
.83695 .6032 L
.83806 .60312 L
.84055 .60289 L
.84288 .60259 L
.84543 .60217 L
.84816 .60161 L
.85374 .60013 L
.85884 .59838 L
.86874 .59386 L
.8779 .58836 L
.89865 .57126 L
.91729 .55043 L
.93789 .52153 L
.97619 .45192 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.625, 174.062},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`003_ooool2o`0000Cooooo00?o
0000ooooooooool00_ooool3o`000?gooooo000=ooooo`04o`000?ooooooooooo`0000Oooooo00Go
0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo0?Gooooo0006ooooo`Go00000_oo
ool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
mOooool000gooooo00Co0000oooooooooooo00002Oooool2o`0000Gooooo0_l0003fooooo`003Ooo
ool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
mOooool000gooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000Co
oooo00?o0000ooooooooool06_ooool7o`000=Cooooo000>ooooo`;o00002Oooool3o`0000Gooooo
00?o0000ooooooooool06Oooool00ol0003oooooooooo`05ooooo`;o0000d_ooool0027ooooo0_l0
000Hooooo`;o00002_ooool00ol0003oooooooooo`3?ooooo`008Oooool00ol0003oooooooooo`0F
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0c_ooool0027ooooo00?o0000oooo
ooooool05Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo0<gooooo000Qooooo`03
o`000?oooooooooo01Gooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`3<ooooo`00
8Oooool2o`0001Gooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`3;ooooo`008Ooo
ool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0b_oo
ool0027ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo
oooo0<Wooooo000Qooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool05Oooool00ol0
003oooooooooo`38ooooo`008Oooool2o`0001;ooooo00?o0000ooooooooool05oooool00ol0003o
ooooooooo`37ooooo`008Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01Sooooo
00?o0000ooooooooool0a_ooool0027ooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`0Jooooo`03o`000?oooooooooo0<Gooooo000Qooooo`03o`000?oooooooooo013ooooo00?o0000
ooooooooool06oooool00ol0003oooooooooo`34ooooo`008Oooool2o`00013ooooo00?o0000oooo
ooooool07Oooool00ol0003oooooooooo`33ooooo`008Oooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo01gooooo00?o0000ooooooooool0`oooool000Sooooo0_l00004ooooo`04o`00
0?ooooooooooooooo`Go00000_ooool3o`0000Gooooo00?o0000ooooooooool03oooool00ol0003o
ooooooooo`0Nooooo`03o`000?oooooooooo0<;ooooo0007ooooo`04o`000?ooooooooooo`0000So
oooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo0<7ooooo0005o`00
00;ooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00;ooooo0_l0000?ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0`Oooool0
00Oooooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooo
oooo0<3ooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00Ko0000ooooooooooooooooo`00
0?ooool4o`0000Gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Sooooo`03o`00
0?oooooooooo0;oooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00Oo0000oooooooooooo
ooooo`000?oooooo000000Sooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Soooo
o`03o`000?oooooooooo0;oooooo0008ooooo`;o00002Oooool3o`0000;ooooo1Ol00004ooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`2nooooo`00
8Oooool2o`0000kooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`2mooooo`008Ooo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0_Ooo
ool0027ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooo
oooo0;cooooo000Qooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0:?ooool00ol0
003oooooooooo`2kooooo`008Oooool2o`0000gooooo00?o0000ooooooooool0:?ooool00ol0003o
ooooooooo`2kooooo`008Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo02[ooooo
00?o0000ooooooooool0^_ooool0027ooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0[ooooo`03o`000?oooooooooo0;Wooooo000Qooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool0:oooool00ol0003oooooooooo`2iooooo`008Oooool2o`0000_ooooo00?o0000oooo
ooooool0;Oooool00ol0003oooooooooo`2hooooo`008Oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo02gooooo00?o0000ooooooooool0^?ooool0027ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo0;Oooooo000Qooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`2fooooo`008Oooool2
o`0000[ooooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`2fooooo`008Oooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool0]Oooool000ko
oooo0_l00004ooooo`04o`000?ooooooooooooooo`Go00001?ooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo037ooooo00?o0000ooooooooool0]Oooool000gooooo00Co0000oooooooo
oooo00002?ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool0<oooool00ol0003oooooooooo`2dooooo`001_ooool5o`0000;ooooo00Co0000oooo
oooooooo00002Oooool00ol0003oooooooooo`04ooooo`;o00002Oooool00ol0003oooooooooo`0c
ooooo`03o`000?oooooooooo0;Cooooo000=ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo03Cooooo00?o0000
ooooooooool0/oooool000gooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooo
oooo000000Cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0dooooo`03o`000?oo
oooooooo0;?ooooo000=ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooooooooooo
o`000004ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0=_ooool00ol0003ooooo
ooooo`2booooo`003_ooool2o`0000Wooooo0ol00005ooooo`;o00002?ooool00ol0003ooooooooo
o`0gooooo`03o`000?oooooooooo0;7ooooo000Qooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool0=oooool00ol0003oooooooooo`2aooooo`008Oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo03Sooooo00?o0000ooooooooool0/?ooool0027ooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo0;3ooooo000Qooooo`;o0000
1oooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo0:oooooo000Qooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`2_ooooo`008Oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo03_ooooo00?o0000ooooooooool0[_ooool0
027ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo
0:kooooo000Qooooo`;o00001_ooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo0:go
oooo000Qooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0?_ooool00ol0003ooooo
ooooo`2/ooooo`008Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo03kooooo00?o
0000ooooooooool0[?ooool0027ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0o
ooooo`03o`000?oooooooooo0:_ooooo000Qooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool0?oooool00ol0003oooooooooo`2[ooooo`008Oooool2o`0000Kooooo00?o0000oooooooo
ool0@?ooool00ol0003oooooooooo`2Zooooo`002?ooool2o`0000Cooooo00?o0000ooooooooool0
0_ooool3o`0000?ooooo0ol00005ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
@?ooool00ol0003oooooooooo`2Zooooo`001oooool01?l0003oooooooooool00009ooooo`05o`00
0?ooooooooooooooool000000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool0@_ooool00ol0003oooooooooo`2Yooooo`001Ol00002ooooo`04o`00
0?ooooooooooo`0000Wooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool0@_ooool00ol0003oooooooooo`2Yooooo`00
1oooool01?l0003oooooooooool00009ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool00_ooool2o`0000Gooooo00?o0000ooooooooool0@oooool00ol0003oooooooooo`2Xooooo`00
1oooool01?l0003oooooooooool00009ooooo`04o`000?ooooooooooooooo`Co00001Oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo04Cooooo00?o0000ooooooooool0Yoooool000Oo
oooo00Co0000oooooooooooo00002?ooool2o`0000?ooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo04Cooooo00?o0000ooooooooool0Yoooool000So
oooo0_l0000:ooooo`04o`000?ooooooooooooooo`Go00001?ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo04Gooooo00?o0000ooooooooool0Y_ooool0027ooooo0_l00004ooooo`03
o`000?oooooooooo04Kooooo00?o0000ooooooooool0Y_ooool0027ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`17ooooo`03o`000?oooooooooo0:Gooooo000Qooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0Aoooool00ol0003oooooooooo`2Uooooo`008Oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0Y?ooool0
027ooooo0_l00004ooooo`03o`000?oooooooooo04Wooooo00?o0000ooooooooool0Xoooool0027o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`19ooooo`03o`000?oooooooooo0:?o
oooo000Qooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0B_ooool00ol0003ooooo
ooooo`2Rooooo`008Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo04_ooooo00?o
0000ooooooooool0X_ooool0027ooooo0_l00003ooooo`03o`000?oooooooooo04cooooo00?o0000
ooooooooool0XOooool0027ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1=oooo
o`03o`000?oooooooooo0:3ooooo000Qooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0COooool00ol0003oooooooooo`2Pooooo`008Oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo04kooooo00?o0000ooooooooool0Woooool0027ooooo0_l00003ooooo`03o`000?oo
oooooooo04oooooo00?o0000ooooooooool0W_ooool0027ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`1?ooooo`03o`000?oooooooooo09kooooo000>ooooo`;o00001?ooool00ol0
003oooooooooo`02ooooo`?o00001Oooool01Ol0003ooooooooooooooooo000005?ooooo00?o0000
ooooooooool0WOooool000gooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`04
ooooo`05o`000?ooooooooooooooool00000Doooool00ol0003oooooooooo`2Mooooo`001_ooool5
o`0000;ooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`04ooooo`;o00000_oo
ool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo09cooooo000=ooooo`04o`000?oooooo
ooooo`0000Wooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000005Gooooo
00?o0000ooooooooool0Voooool000gooooo00Co0000oooooooooooo00002Oooool00ol0003ooooo
ooooo`04ooooo`05o`000?ooooooooooooooool00000EOooool00ol0003oooooooooo`2Kooooo`00
3Oooool01?l0003oooooooooool00008ooooo`;o00001_ooool01Ol0003ooooooooooooooooo0000
05Kooooo00?o0000ooooooooool0V_ooool000kooooo0_l0000:ooooo`03o`000?oooooooooo00Co
oooo00Go0000ooooooooooooooooo`00001Gooooo`03o`000?oooooooooo09Wooooo000Qooooo`;o
00000_ooool00ol0003oooooooooo`1Fooooo`03o`000?oooooooooo09Sooooo000Qooooo`04o`00
0?ooooooooooo`0005[ooooo00?o0000ooooooooool0Uoooool0027ooooo00Co0000oooooooooooo
0000Foooool00ol0003oooooooooo`2Fooooo`008Oooool01?l0003oooooooooool0001Kooooo`03
o`000?oooooooooo09Kooooo000Qooooo`;o000000?oooooo`000?ooool0Foooool00ol0003ooooo
ooooo`2Eooooo`008Oooool01?l0003oooooooooool0001Mooooo`03o`000?oooooooooo09Cooooo
000Qooooo`04o`000?ooooooooooo`0005kooooo00?o0000ooooooooool0Toooool0027ooooo00Co
0000oooooooooooo0000Goooool00ol0003oooooooooo`2Booooo`008Oooool2o`000003ooooool0
003ooooo05oooooo0_l0002Booooo`008Oooool01?l0003oooooooooool0001Rooooo`03o`000?oo
oooooooo08oooooo000Qooooo`04o`000?ooooooooooo`0006?ooooo00?o0000ooooooooool0S_oo
ool0027ooooo00Co0000oooooooooooo0000I?ooool00ol0003oooooooooo`2=ooooo`008Oooool3
o`0006Kooooo0_l0002=ooooo`008Oooool00ol0003oooooo`00001Xooooo`03o`000?oooooooooo
08[ooooo0008ooooo`;o00001?ooool00ol0003oooooooooo`03ooooo`;o00000oooool3o`0000Go
oooo00?o0000ooooool00000JOooool00ol0003oooooooooo`29ooooo`001oooool01?l0003ooooo
ooooool00008ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooo000006[ooooo00?o0000ooooooooool0R?ooool000Go00000_ooool01?l0
003oooooooooool00008ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool00_oo
ool3o`0006_ooooo0_l00028ooooo`001oooool01?l0003oooooooooool00008ooooo`04o`000?oo
ooooooooo`0000Gooooo00?o0000ooooooooool00_ooool00ol0003oooooo`00001]ooooo`;o0000
Q_ooool000Oooooo00Co0000oooooooooooo00002?ooool01Ol0003oooooooooool0003ooooo00Co
00001Oooool00ol0003oooooo`00001_ooooo`03o`000?oooooooooo08?ooooo0007ooooo`04o`00
0?ooooooooooo`0000Sooooo00Ko0000oooooooooooo0000ooooool00008ooooo`03o`000?oooooo
0000073ooooo0_l00023ooooo`002?ooool2o`0000[ooooo0_l00002ooooo`Go00001?ooool3o`00
07;ooooo0_l00021ooooo`008Oooool00ol0003oooooo`00001dooooo`;o0000Ooooool0027ooooo
0_l0001gooooo`;o0000OOooool0027ooooo0_l0001iooooo`;o0000Noooool0027ooooo0_l0001k
ooooo`;o0000NOooool0027ooooo0_l0001mooooo`;o0000Moooool0027ooooo0_l0000Oooooo`;o
00001?ooool00ol0003oooooooooo`02ooooo`?o00007oooool3o`0001oooooo0ol00004ooooo`03
o`000?oooooooooo00;ooooo0ol00002ooooo`;o00006oooool5o`0001gooooo1Ol00003ooooo`03
o`000?oooooooooo00;ooooo0ol0000Oooooo`?o00001_ooool0027ooooo0_l0000Nooooo`04o`00
0?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Oooooo`03o`000?oooooooooo
01oooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000000?ooooo0ol0000I
ooooo`04o`000?ooooooooooo`0001kooooo00Co0000oooooooooooo00001oooool01Ol0003ooooo
oooooooooooo000001gooooo00?o0000ooooooooool00_l00005ooooo`008Oooool2o`0001kooooo
00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo01oo
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`04ooooo`?o00005oooool00ol0003o
ooooooooo`0Oooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool07Oooool00ol0003o
ooooo`000005ooooo`008Oooool2o`0001kooooo00Co0000oooooooooooo00002oooool00ol0003o
ooooooooo`0Mooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`07ooooo`?o00005Oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool07Oooool2o`0000Kooooo000Qooooo`;o00007_ooool01?l0003ooooo
ooooool00007ooooo`Co00008?ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Oo
oooo1?l0000=ooooo`Go00003Oooool01Ol0003ooooooooooooooooo000001gooooo00Go0000oooo
ooooooooooooo`000007ooooo`Co00007oooool01?l0003oooooooooool00005ooooo`008Oooool2
o`0001kooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0Pooooo`;o00008?oo
ool2o`0000Wooooo00?o0000ooooooooool04oooool5o`0000Sooooo00Go0000oooooooooooooooo
o`00000Mooooo`05o`000?ooooooooooooooool000001oooool00ol0003oooooooooo`0Oooooo`05
o`000?ooooooooooooooool000001Oooool0027ooooo0_l0000Oooooo`;o00002?ooool5o`0001oo
oooo00?o0000ooooooooool07oooool00ol0003oooooooooo`07ooooo`Go00005_ooool5o`0000Co
oooo0ol0000Oooooo`?o00002?ooool5o`0001gooooo1?l00006ooooo`008Oooool2o`0009Wooooo
1_l0001<ooooo`03o`000?oooooooooo00Sooooo000Qooooo`03o`000?oooooooooo09kooooo0_l0
001:ooooo`03o`000?oooooooooo00Sooooo000Qooooo`03o`000?oooooooooo0:3ooooo0ol00016
ooooo`03o`000?oooooooooo00Wooooo000Qooooo`03o`000?oooooooooo0:?ooooo00?o0000oooo
ooooool0@_ooool00ol0003oooooooooo`0:ooooo`006oooooono`0000008Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool2o`0000Oooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01Oooool2o`0000Kooooo00?o0000ooooooooool01?ooool0027ooooo00?o
0000ooooooooool0Yoooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo00_ooooo000Q
ooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool0>oooool00ol0003oooooooooo`0<
ooooo`008Oooool2o`000:[ooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0=oooo
o`008Oooool00ol0003oooooooooo`2Zooooo`03o`000?oooooooooo03Sooooo00?o0000oooooooo
ool03Oooool0027ooooo00?o0000ooooooooool0Zoooool00ol0003oooooooooo`0fooooo`03o`00
0?oooooooooo00kooooo000Qooooo`03o`000?oooooooooo0:cooooo00?o0000ooooooooool0=Ooo
ool00ol0003oooooooooo`0>ooooo`008Oooool2o`000:kooooo00?o0000ooooooooool0<oooool0
0ol0003oooooooooo`0?ooooo`008Oooool00ol0003oooooooooo`2^ooooo`03o`000?oooooooooo
037ooooo00?o0000ooooooooool04?ooool0027ooooo00?o0000ooooooooool0[oooool00ol0003o
ooooooooo`0`ooooo`03o`000?oooooooooo013ooooo000Qooooo`03o`000?oooooooooo0;3ooooo
00?o0000ooooooooool0;_ooool00ol0003oooooooooo`0Aooooo`008Oooool2o`000;;ooooo00?o
0000ooooooooool0;Oooool00ol0003oooooooooo`0Aooooo`008Oooool00ol0003oooooooooo`2b
ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool04_ooool0027ooooo00?o0000oooo
ooooool0/oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo01?ooooo000Qooooo`03
o`000?oooooooooo0;Cooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Dooooo`00
8Oooool2o`000;Kooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0Eooooo`008Ooo
ool00ol0003oooooooooo`2fooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool05_oo
ool000Sooooo0_l00004ooooo`03o`000?oooooooooo00?ooooo0_l00003ooooo`?o00001Oooool0
0ol0003oooooooooo`2gooooo`;o00008_ooool00ol0003oooooooooo`0Gooooo`001oooool01?l0
003oooooooooool00008ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo0;Wooooo00?o0000ooooooooool07Oooool2o`0001[ooooo
0007ooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00001Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo0;[ooooo00?o0000ooooooooool06oooool00ol0003o
ooooooooo`0Jooooo`001oooool01?l0003oooooooooool00008ooooo`04o`000?ooooooooooo`00
00Gooooo00?o0000ooooooooool00_ooool2o`000;cooooo00?o0000ooooooooool06Oooool00ol0
003oooooooooo`0Kooooo`001oooool01?l0003oooooooooool00008ooooo`05o`000?oooooooooo
o`000?ooool01?l00005ooooo`03o`000?oooooooooo0;cooooo0_l0000Hooooo`03o`000?oooooo
oooo01cooooo0007ooooo`04o`000?ooooooooooo`0000Sooooo00Ko0000oooooooooooo0000oooo
ool00008ooooo`03o`000?oooooooooo0;kooooo0_l0000Eooooo`03o`000?oooooooooo01gooooo
0008ooooo`;o00002_ooool2o`0000;ooooo1Ol00004ooooo`03o`000?oooooooooo0<3ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Nooooo`008Oooool2o`000<;ooooo00?o0000
ooooooooool03_ooool2o`00027ooooo000Qooooo`03o`000?oooooooooo0<;ooooo1?l00009oooo
o`?o00008oooool0027ooooo00?o0000ooooooooool0a_ooool9o`0002Kooooo000Qooooo`03o`00
0?oooooooooo0?Gooooo000Qooooo`;o0000m_ooool0027ooooo00?o0000ooooooooool0mOooool0
027ooooo00?o0000ooooooooool0mOooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_oo
ool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00001\
\>"],
  ImageRangeCache->{{{0, 280.625}, {173.062, 0}} -> {-0.412186, -0.327153, \
0.0124266, 0.00241569}}]
}, Closed]],

Cell[BoxData[
    \(L[t_, y_] := \[PartialD]\_{t, 2}y[t] + 5\ \[PartialD]\_t y[t] + 
        6\ y[t] - f[t]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[t, w]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(-t\^2\)\ \((\(-1\) + UnitStep[t])\)\)], "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 365},
WindowMargins->{{36, Automatic}, {Automatic, 28}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3307101380-4970032"->{
    Cell[2216, 73, 481, 11, 71, "Print",
      CellTags->"Info3307101380-4970032"]},
  "Info3307101381-9388658"->{
    Cell[2848, 93, 192, 3, 39, "Print",
      CellTags->"Info3307101381-9388658"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3307101380-4970032", 250208, 6972},
  {"Info3307101381-9388658", 250323, 6975}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 80, 2, 65, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[1881, 59, 87, 2, 56, "Section",
  Evaluatable->False],
Cell[1971, 63, 107, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[2103, 69, 110, 2, 27, "Input"],
Cell[2216, 73, 481, 11, 71, "Print",
  CellTags->"Info3307101380-4970032"]
}, Closed]],

Cell[CellGroupData[{
Cell[2734, 89, 111, 2, 27, "Input"],
Cell[2848, 93, 192, 3, 39, "Print",
  CellTags->"Info3307101381-9388658"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3089, 102, 105, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3219, 108, 172, 3, 59, "Input"],
Cell[3394, 113, 7469, 196, 94, 2317, 126, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10900, 314, 192, 4, 59, "Input"],
Cell[11095, 320, 10673, 270, 96, 3464, 175, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21817, 596, 107, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21949, 602, 113, 2, 46, "Subsection",
  Evaluatable->False],
Cell[22065, 606, 229, 5, 87, "Input"],

Cell[CellGroupData[{
Cell[22319, 615, 95, 2, 27, "Input"],
Cell[22417, 619, 160, 3, 35, "Message"],
Cell[22580, 624, 160, 3, 35, "Message"],
Cell[22743, 629, 160, 3, 35, "Message"],
Cell[22906, 634, 162, 3, 35, "Message"],
Cell[23071, 639, 21952, 538, 141, 4496, 317, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[45072, 1183, 126, 2, 46, "Subsection",
  Evaluatable->False],
Cell[45201, 1187, 114, 2, 29, "Input"],
Cell[45318, 1191, 129, 3, 43, "Input"],
Cell[45450, 1196, 92, 2, 29, "Input"],

Cell[CellGroupData[{
Cell[45567, 1202, 151, 4, 43, "Input"],
Cell[45721, 1208, 15353, 451, 183, 4048, 306, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[61111, 1664, 154, 4, 43, "Input"],
Cell[61268, 1670, 14534, 454, 183, 4302, 322, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[75839, 2129, 154, 4, 43, "Input"],
Cell[75996, 2135, 17899, 467, 183, 3710, 286, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[93932, 2607, 85, 2, 27, "Input"],
Cell[94020, 2611, 16807, 531, 141, 5198, 382, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[110864, 3147, 93, 2, 27, "Input"],
Cell[110960, 3151, 35157, 1032, 131, 9959, 715, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[146178, 4190, 108, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[146311, 4196, 131, 3, 46, "Subsection",
  Evaluatable->False],
Cell[146445, 4201, 202, 5, 63, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[146684, 4211, 121, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[146830, 4217, 152, 4, 43, "Input"],
Cell[146985, 4223, 20039, 549, 141, 5104, 359, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[167085, 4779, 107, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[167217, 4785, 282, 5, 99, "Input"],
Cell[167502, 4792, 22960, 665, 76, 9700, 495, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[190511, 5463, 81, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[190617, 5469, 645, 17, 43, "Input"],
Cell[191265, 5488, 607, 16, 87, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[191909, 5509, 81, 2, 27, "Input"],
Cell[191993, 5513, 133, 3, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[192163, 5521, 91, 2, 27, "Input"],
Cell[192257, 5525, 146, 3, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[192440, 5533, 76, 2, 27, "Input"],
Cell[192519, 5537, 112, 2, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[192668, 5544, 85, 2, 27, "Input"],
Cell[192756, 5548, 28577, 641, 183, 5059, 345, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]],
Cell[221348, 6192, 133, 3, 28, "Input"],

Cell[CellGroupData[{
Cell[221506, 6199, 76, 2, 27, "Input"],
Cell[221585, 6203, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[221669, 6210, 81, 2, 36, "Section",
  Evaluatable->False],
Cell[221753, 6214, 201, 5, 63, "Input"],

Cell[CellGroupData[{
Cell[221979, 6223, 823, 21, 43, "Input"],
Cell[222805, 6246, 1038, 22, 168, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[223880, 6273, 81, 2, 27, "Input"],
Cell[223964, 6277, 433, 7, 64, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[224434, 6289, 103, 2, 27, "Input"],
Cell[224540, 6293, 694, 12, 103, "Output"]
}, Closed]],
Cell[225249, 6308, 81, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[225355, 6314, 85, 2, 27, "Input"],
Cell[225443, 6318, 23523, 611, 183, 5427, 382, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]],
Cell[248981, 6932, 146, 3, 28, "Input"],

Cell[CellGroupData[{
Cell[249152, 6939, 76, 2, 27, "Input"],
Cell[249231, 6943, 71, 1, 29, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

